/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.textgeneration;

import com.ibm.watsonx.ai.core.Json;
import com.ibm.watsonx.ai.textgeneration.TextGenerationHandler;
import com.ibm.watsonx.ai.textgeneration.TextGenerationRequest;
import com.ibm.watsonx.ai.textgeneration.TextGenerationResponse;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;

public interface TextGenerationProvider {
    public TextGenerationResponse generate(TextGenerationRequest var1);

    public CompletableFuture<Void> generateStreaming(TextGenerationRequest var1, TextGenerationHandler var2);

    default public Void handlerError(Throwable t, TextGenerationHandler handler) {
        Optional.ofNullable(t).ifPresent(handler::onError);
        return null;
    }

    default public Flow.Subscriber<String> subscriber(final TextGenerationHandler handler) {
        return new Flow.Subscriber<String>(){
            private Flow.Subscription subscription;
            private volatile String modelId;
            private volatile int inputTokenCount;
            private volatile int generatedTokenCount;
            private volatile String stopReason;
            private volatile boolean success = true;
            private volatile boolean pendingSSEError = false;
            private final StringBuffer buffer = new StringBuffer();

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                this.subscription.request(1L);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(String partialMessage) {
                block23: {
                    try {
                        TextGenerationResponse.Result result;
                        if (Objects.isNull(partialMessage) || partialMessage.isBlank()) {
                            return;
                        }
                        if (partialMessage.startsWith("event: error")) {
                            this.pendingSSEError = true;
                            return;
                        }
                        if (!partialMessage.startsWith("data:")) {
                            return;
                        }
                        String messageData = partialMessage.split("data: ")[1];
                        if (this.pendingSSEError) {
                            this.pendingSSEError = false;
                            throw new RuntimeException(messageData);
                        }
                        TextGenerationResponse chunk = (TextGenerationResponse)Json.fromJson((String)messageData, TextGenerationResponse.class);
                        if (chunk.results().size() == 0) {
                            return;
                        }
                        if (Objects.isNull(this.modelId) && Objects.nonNull(chunk.modelId())) {
                            this.modelId = chunk.modelId();
                        }
                        if (Objects.nonNull((result = chunk.results().get(0)).inputTokenCount())) {
                            this.inputTokenCount += result.inputTokenCount().intValue();
                        }
                        if (Objects.nonNull(result.generatedTokenCount())) {
                            this.generatedTokenCount += result.generatedTokenCount().intValue();
                        }
                        if (Objects.nonNull(result.stopReason())) {
                            this.stopReason = result.stopReason();
                        }
                        if (!Objects.nonNull(result.generatedText()) || result.generatedText().isEmpty()) break block23;
                        this.buffer.append(result.generatedText());
                        TextGenerationHandler textGenerationHandler = handler;
                        synchronized (textGenerationHandler) {
                            handler.onPartialResponse(result.generatedText());
                        }
                    }
                    catch (RuntimeException e) {
                        this.onError(e);
                        this.success = !handler.failOnFirstError();
                    }
                    finally {
                        if (this.success) {
                            this.subscription.request(1L);
                        } else {
                            this.subscription.cancel();
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable throwable) {
                TextGenerationHandler textGenerationHandler = handler;
                synchronized (textGenerationHandler) {
                    handler.onError(throwable);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onComplete() {
                try {
                    List<TextGenerationResponse.Result> result = List.of(new TextGenerationResponse.Result(this.buffer.toString(), this.stopReason, this.generatedTokenCount, this.inputTokenCount, null, null, null, null));
                    TextGenerationHandler textGenerationHandler = handler;
                    synchronized (textGenerationHandler) {
                        handler.onCompleteResponse(new TextGenerationResponse(this.modelId, null, null, result));
                    }
                }
                catch (RuntimeException e) {
                    this.onError(e);
                }
            }
        };
    }
}

