/*
 * Decompiled with CFR 0.152.
 */
package com.incountry.residence.sdk;

import com.incountry.residence.sdk.tools.crypto.Crypto;
import com.incountry.residence.sdk.tools.keyaccessor.SecretKeyAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StorageConfig {
    public static final String MSG_SECURE = "[SECURE[%s]]";
    public static final String PARAM_ENV_ID = "INC_ENVIRONMENT_ID";
    public static final String PARAM_API_KEY = "INC_API_KEY";
    public static final String PARAM_ENDPOINT = "INC_ENDPOINT";
    public static final String PARAM_CLIENT_ID = "INC_CLIENT_ID";
    public static final String PARAM_CLIENT_SECRET = "INC_CLIENT_SECRET";
    private String envId;
    private String apiKey;
    private String endPoint;
    private SecretKeyAccessor secretKeyAccessor;
    private List<Crypto> customEncryptionConfigsList;
    private String clientId;
    private String clientSecret;
    private boolean normalizeKeys;
    private String endpointMask;
    private String countriesEndpoint;
    private Integer httpTimeout;
    private Map<String, String> authEndpoints;
    private String defaultAuthEndpoint;
    private Integer maxHttpPoolSize;
    private Integer maxHttpConnectionsPerRoute;

    public String getEnvId() {
        return this.envId;
    }

    public StorageConfig setEnvId(String envId) {
        this.envId = envId;
        return this;
    }

    public StorageConfig useEnvIdFromEnv() {
        this.envId = StorageConfig.loadFromEnv(PARAM_ENV_ID);
        return this;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public StorageConfig setApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public StorageConfig useApiKeyFromEnv() {
        this.apiKey = StorageConfig.loadFromEnv(PARAM_API_KEY);
        return this;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    public StorageConfig setEndPoint(String endPoint) {
        this.endPoint = endPoint;
        return this;
    }

    public StorageConfig useEndPointFromEnv() {
        this.endPoint = StorageConfig.loadFromEnv(PARAM_ENDPOINT);
        return this;
    }

    public SecretKeyAccessor getSecretKeyAccessor() {
        return this.secretKeyAccessor;
    }

    public StorageConfig setSecretKeyAccessor(SecretKeyAccessor secretKeyAccessor) {
        this.secretKeyAccessor = secretKeyAccessor;
        return this;
    }

    public List<Crypto> getCustomEncryptionConfigsList() {
        return this.customEncryptionConfigsList == null ? null : new ArrayList<Crypto>(this.customEncryptionConfigsList);
    }

    public StorageConfig setCustomEncryptionConfigsList(List<Crypto> customEncryptionConfigsList) {
        this.customEncryptionConfigsList = customEncryptionConfigsList;
        return this;
    }

    public boolean isNormalizeKeys() {
        return this.normalizeKeys;
    }

    public StorageConfig setNormalizeKeys(boolean normalizeKeys) {
        this.normalizeKeys = normalizeKeys;
        return this;
    }

    public String getClientId() {
        return this.clientId;
    }

    public StorageConfig setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public StorageConfig useClientIdFromEnv() {
        this.clientId = StorageConfig.loadFromEnv(PARAM_CLIENT_ID);
        return this;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public StorageConfig setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public StorageConfig useClientSecretFromEnv() {
        this.clientSecret = StorageConfig.loadFromEnv(PARAM_CLIENT_SECRET);
        return this;
    }

    public Map<String, String> getAuthEndpoints() {
        return this.authEndpoints != null ? new HashMap<String, String>(this.authEndpoints) : null;
    }

    public StorageConfig setAuthEndpoints(Map<String, String> authEndpoints) {
        this.authEndpoints = authEndpoints;
        return this;
    }

    public String getDefaultAuthEndpoint() {
        return this.defaultAuthEndpoint;
    }

    public StorageConfig setDefaultAuthEndpoint(String defaultAuthEndpoint) {
        this.defaultAuthEndpoint = defaultAuthEndpoint;
        return this;
    }

    public Integer getHttpTimeout() {
        return this.httpTimeout;
    }

    public StorageConfig setHttpTimeout(Integer httpTimeout) {
        this.httpTimeout = httpTimeout;
        return this;
    }

    public Integer getMaxHttpPoolSize() {
        return this.maxHttpPoolSize;
    }

    public StorageConfig setMaxHttpPoolSize(Integer maxHttpPoolSize) {
        this.maxHttpPoolSize = maxHttpPoolSize;
        return this;
    }

    public String getEndpointMask() {
        return this.endpointMask;
    }

    public Integer getMaxHttpConnectionsPerRoute() {
        return this.maxHttpConnectionsPerRoute;
    }

    public StorageConfig setMaxHttpConnectionsPerRoute(Integer maxHttpConnectionsPerRoute) {
        this.maxHttpConnectionsPerRoute = maxHttpConnectionsPerRoute;
        return this;
    }

    public StorageConfig setEndpointMask(String endpointMask) {
        this.endpointMask = endpointMask;
        return this;
    }

    public String getCountriesEndpoint() {
        return this.countriesEndpoint;
    }

    public StorageConfig setCountriesEndpoint(String countriesEndpoint) {
        this.countriesEndpoint = countriesEndpoint;
        return this;
    }

    public StorageConfig copy() {
        StorageConfig newInstance = new StorageConfig();
        newInstance.setEnvId(this.getEnvId());
        newInstance.setApiKey(this.getApiKey());
        newInstance.setEndPoint(this.getEndPoint());
        newInstance.setSecretKeyAccessor(this.getSecretKeyAccessor());
        newInstance.setCustomEncryptionConfigsList(this.getCustomEncryptionConfigsList());
        newInstance.setNormalizeKeys(this.isNormalizeKeys());
        newInstance.setClientId(this.getClientId());
        newInstance.setClientSecret(this.getClientSecret());
        newInstance.setEndpointMask(this.getEndpointMask());
        newInstance.setCountriesEndpoint(this.getCountriesEndpoint());
        newInstance.setHttpTimeout(this.getHttpTimeout());
        newInstance.setAuthEndpoints(this.getAuthEndpoints());
        newInstance.setDefaultAuthEndpoint(this.getDefaultAuthEndpoint());
        newInstance.setMaxHttpPoolSize(this.getMaxHttpPoolSize());
        return newInstance;
    }

    public String toString() {
        return "StorageConfig{envId='" + this.hideParam(this.envId) + '\'' + ", apiKey='" + this.hideParam(this.apiKey) + '\'' + ", endPoint='" + this.endPoint + '\'' + ", secretKeyAccessor=" + this.secretKeyAccessor + ", customEncryptionConfigsList=" + this.customEncryptionConfigsList + ", ignoreKeyCase=" + this.normalizeKeys + ", clientId='" + this.hideParam(this.clientId) + '\'' + ", clientSecret='" + this.hideParam(this.clientSecret) + '\'' + ", endpointMask='" + this.endpointMask + '\'' + ", countriesEndpoint='" + this.countriesEndpoint + '\'' + ", authEndpointMap='" + this.authEndpoints + '\'' + ", defaultAuthEndpoint='" + this.defaultAuthEndpoint + '\'' + ", httpTimeout='" + this.httpTimeout + '\'' + ", httpPoolSize='" + this.maxHttpPoolSize + '\'' + '}';
    }

    private String hideParam(String param) {
        return param != null ? String.format(MSG_SECURE, param.hashCode()) : null;
    }

    private static String loadFromEnv(String key) {
        return System.getenv(key);
    }
}

