/*
 * Decompiled with CFR 0.152.
 */
package com.incountry.residence.sdk;

import com.incountry.residence.sdk.Storage;
import com.incountry.residence.sdk.StorageConfig;
import com.incountry.residence.sdk.dto.BatchRecord;
import com.incountry.residence.sdk.dto.MigrateResult;
import com.incountry.residence.sdk.dto.Record;
import com.incountry.residence.sdk.dto.search.FindFilterBuilder;
import com.incountry.residence.sdk.dto.search.StringField;
import com.incountry.residence.sdk.tools.crypto.CryptoManager;
import com.incountry.residence.sdk.tools.dao.Dao;
import com.incountry.residence.sdk.tools.dao.impl.HttpDaoImpl;
import com.incountry.residence.sdk.tools.exceptions.StorageClientException;
import com.incountry.residence.sdk.tools.exceptions.StorageCryptoException;
import com.incountry.residence.sdk.tools.exceptions.StorageServerException;
import com.incountry.residence.sdk.tools.http.TokenClient;
import com.incountry.residence.sdk.tools.http.impl.ApiKeyTokenClient;
import com.incountry.residence.sdk.tools.http.impl.OAuthTokenClient;
import com.incountry.residence.sdk.tools.keyaccessor.SecretKeyAccessor;
import com.incountry.residence.sdk.tools.proxy.ProxyUtils;
import java.util.List;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StorageImpl
implements Storage {
    private static final Logger LOG = LogManager.getLogger(StorageImpl.class);
    private static final String MSG_ERR_PASS_ENV = "Please pass environment_id param or set INC_ENVIRONMENT_ID env var";
    private static final String MSG_ERR_AUTH_DUPL = "Either apiKey or clientId/clientSecret can be used at the same moment, not both";
    private static final String MSG_ERR_PASS_API_KEY = "Please pass api_key param or set INC_API_KEY env var";
    private static final String MSG_ERR_NULL_BATCH = "Can't write empty batch";
    private static final String MSG_ERR_NULL_COUNTRY = "Country can't be null";
    private static final String MSG_ERR_NULL_KEY = "Key can't be null";
    private static final String MSG_ERR_NULL_FILTERS = "Filters can't be null";
    private static final String MSG_ERR_NULL_RECORD = "Can't write null record";
    private static final String MSG_ERR_MIGR_NOT_SUPPORT = "Migration is not supported when encryption is off";
    private static final String MSG_ERR_MIGR_ERROR_LIMIT = "Limit can't be < 1";
    private static final String MSG_ERR_CUSTOM_ENCRYPTION_ACCESSOR = "Custom encryption can be used only with not null SecretKeyAccessor";
    private static final String MSG_ERR_PASS_CLIENT_ID = "Please pass clientId in configuration or set INC_CLIENT_ID env var";
    private static final String MSG_ERR_PASS_CLIENT_SECRET = "Please pass clientSecret in configuration or set INC_CLIENT_SECRET env var";
    private static final String MSG_ERR_PASS_AUTH = "Please pass (clientId, clientSecret) in configuration or set (INC_CLIENT_ID, INC_CLIENT_SECRET) env vars";
    private static final String MSG_ERR_ILLEGAL_TIMEOUT = "Connection timeout can't be <1. Expected 'null' or positive value, received=%d";
    private static final String MSG_ERR_CONNECTION_POOL = "HTTP pool size can't be < 1. Expected 'null' or positive value, received=%d";
    private static final String MSG_ERR_MAX_CONNECTIONS_PER_ROUTE = "Max HTTP connections count per route can't be < 1. Expected 'null' or positive value, received=%d";
    private static final String MSG_FOUND_NOTHING = "Nothing was found";
    private static final String MSG_SIMPLE_SECURE = "[SECURE]";
    private static final int DEFAULT_HTTP_TIMEOUT = 30;
    private static final int DEFAULT_MAX_HTTP_CONNECTIONS = 20;
    private CryptoManager cryptoManager;
    private Dao dao;
    private boolean encrypted;

    private StorageImpl() {
    }

    public static Storage getInstance() throws StorageClientException {
        return StorageImpl.getInstance((SecretKeyAccessor)null);
    }

    public static Storage getInstance(SecretKeyAccessor secretKeyAccessor) throws StorageClientException {
        StorageConfig config = new StorageConfig().setSecretKeyAccessor(secretKeyAccessor).useEnvIdFromEnv().useApiKeyFromEnv().useEndPointFromEnv().useClientIdFromEnv().useClientSecretFromEnv();
        return StorageImpl.getInstance(config);
    }

    public static Storage getInstance(String environmentID, String apiKey, String endpoint, SecretKeyAccessor secretKeyAccessor) throws StorageClientException {
        StorageConfig config = new StorageConfig().setSecretKeyAccessor(secretKeyAccessor).setEnvId(environmentID).setApiKey(apiKey).setEndPoint(endpoint);
        return StorageImpl.getInstance(config);
    }

    public static Storage getInstance(StorageConfig config) throws StorageClientException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("StorageImpl constructor params config={}", (Object)config);
        }
        if (config.getSecretKeyAccessor() == null && config.getCustomEncryptionConfigsList() != null && !config.getCustomEncryptionConfigsList().isEmpty()) {
            LOG.error(MSG_ERR_CUSTOM_ENCRYPTION_ACCESSOR);
            throw new StorageClientException(MSG_ERR_CUSTOM_ENCRYPTION_ACCESSOR);
        }
        return StorageImpl.getInstance(config, null);
    }

    public static Storage getInstance(String environmentID, SecretKeyAccessor secretKeyAccessor, Dao dao) throws StorageClientException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("StorageImpl constructor params (environmentID={} , secretKeyAccessor={} , dao={})", environmentID != null ? String.format("[SECURE[%s]]", environmentID.hashCode()) : null, (Object)secretKeyAccessor, (Object)dao);
        }
        StorageConfig config = new StorageConfig().setEnvId(environmentID).setSecretKeyAccessor(secretKeyAccessor);
        return StorageImpl.getInstance(config, dao);
    }

    private static Storage getInstance(StorageConfig config, Dao dao) throws StorageClientException {
        StorageImpl.checkNotNull(config.getEnvId(), MSG_ERR_PASS_ENV);
        if (config.getApiKey() != null && config.getClientId() != null) {
            LOG.error(MSG_ERR_AUTH_DUPL);
            throw new StorageClientException(MSG_ERR_AUTH_DUPL);
        }
        StorageImpl instance = new StorageImpl();
        instance.dao = StorageImpl.initDao(config, dao);
        instance.encrypted = config.getSecretKeyAccessor() != null;
        instance.cryptoManager = new CryptoManager(config.getSecretKeyAccessor(), config.getEnvId(), config.getCustomEncryptionConfigsList(), config.isNormalizeKeys());
        return (Storage)ProxyUtils.createLoggingProxyForPublicMethods(instance);
    }

    private static CloseableHttpClient initHttpClient(Integer httpTimeout, Integer poolSize, Integer connectionsPerRoute) {
        if (httpTimeout == null) {
            httpTimeout = 30;
        }
        httpTimeout = httpTimeout * 1000;
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(httpTimeout.intValue()).setSocketTimeout(httpTimeout.intValue()).build();
        HttpClientBuilder builder = HttpClients.custom().setDefaultRequestConfig(requestConfig);
        if (poolSize == null) {
            poolSize = 20;
        }
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(poolSize.intValue());
        connectionManager.setDefaultMaxPerRoute((connectionsPerRoute != null ? connectionsPerRoute : poolSize).intValue());
        builder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        return builder.build();
    }

    private static Dao initDao(StorageConfig config, Dao dao) throws StorageClientException {
        if (dao == null) {
            TokenClient tokenClient;
            Integer httpTimeout = config.getHttpTimeout();
            Integer httpPoolSize = config.getMaxHttpPoolSize();
            Integer connectionsPerRoute = config.getMaxHttpConnectionsPerRoute();
            StorageImpl.checkPositiveOrNull(httpTimeout, MSG_ERR_ILLEGAL_TIMEOUT);
            StorageImpl.checkPositiveOrNull(httpPoolSize, MSG_ERR_CONNECTION_POOL);
            StorageImpl.checkPositiveOrNull(connectionsPerRoute, MSG_ERR_MAX_CONNECTIONS_PER_ROUTE);
            CloseableHttpClient httpClient = StorageImpl.initHttpClient(httpTimeout, httpPoolSize, connectionsPerRoute);
            if (config.getClientId() != null && config.getClientSecret() != null) {
                StorageImpl.checkNotNull(config.getClientId(), MSG_ERR_PASS_CLIENT_ID);
                StorageImpl.checkNotNull(config.getClientSecret(), MSG_ERR_PASS_CLIENT_SECRET);
                tokenClient = new OAuthTokenClient(config.getDefaultAuthEndpoint(), config.getAuthEndpoints(), config.getEnvId(), config.getClientId(), config.getClientSecret(), httpClient);
                tokenClient = (TokenClient)ProxyUtils.createLoggingProxyForPublicMethods(tokenClient);
            } else if (config.getApiKey() != null) {
                StorageImpl.checkNotNull(config.getApiKey(), MSG_ERR_PASS_API_KEY);
                tokenClient = new ApiKeyTokenClient(config.getApiKey());
            } else {
                LOG.error(MSG_ERR_PASS_AUTH);
                throw new StorageClientException(MSG_ERR_PASS_AUTH);
            }
            return new HttpDaoImpl(config.getEnvId(), config.getEndPoint(), config.getEndpointMask(), config.getCountriesEndpoint(), tokenClient, httpClient);
        }
        return dao;
    }

    private static void checkPositiveOrNull(Integer intValue, String errorMessage) throws StorageClientException {
        if (intValue != null && intValue < 1) {
            String errMessage = String.format(errorMessage, intValue);
            LOG.error(errMessage);
            throw new StorageClientException(errMessage);
        }
    }

    private static void checkNotNull(Object parameter, String nullErrorMessage) throws StorageClientException {
        if (parameter == null || String.valueOf(parameter).isEmpty()) {
            LOG.error(nullErrorMessage);
            throw new StorageClientException(nullErrorMessage);
        }
    }

    private void checkParameters(String country, String key) throws StorageClientException {
        StorageImpl.checkNotNull(country, MSG_ERR_NULL_COUNTRY);
        StorageImpl.checkNotNull(key, MSG_ERR_NULL_KEY);
    }

    @Override
    public Record write(String country, Record record) throws StorageClientException, StorageServerException, StorageCryptoException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("write params (country={} , record={})", (Object)country, record != null ? String.format("[SECURE[%s]]", record.hashCode()) : null);
        }
        StorageImpl.checkNotNull(record, MSG_ERR_NULL_RECORD);
        this.checkParameters(country, record.getRecordKey());
        this.dao.createRecord(country, record, this.cryptoManager);
        return record;
    }

    @Override
    public Record read(String country, String recordKey) throws StorageClientException, StorageServerException, StorageCryptoException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("read params (country={} , recordKey={})", (Object)country, (Object)(recordKey != null ? MSG_SIMPLE_SECURE : null));
        }
        this.checkParameters(country, recordKey);
        Record record = this.dao.read(country, recordKey, this.cryptoManager);
        if (LOG.isTraceEnabled()) {
            LOG.trace("read results ({})", record != null ? Integer.valueOf(record.hashCode()) : null);
        }
        return record;
    }

    @Override
    public MigrateResult migrate(String country, int limit) throws StorageClientException, StorageServerException, StorageCryptoException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("migrate params (country={} , limit={})", (Object)country, (Object)limit);
        }
        if (!this.encrypted) {
            LOG.error(MSG_ERR_MIGR_NOT_SUPPORT);
            throw new StorageClientException(MSG_ERR_MIGR_NOT_SUPPORT);
        }
        if (limit < 1) {
            LOG.error(MSG_ERR_MIGR_ERROR_LIMIT);
            throw new StorageClientException(MSG_ERR_MIGR_ERROR_LIMIT);
        }
        FindFilterBuilder builder = FindFilterBuilder.create().limitAndOffset(limit, 0).keyNotEq(StringField.VERSION, String.valueOf(this.cryptoManager.getCurrentSecretVersion()));
        BatchRecord batchRecord = this.find(country, builder);
        if (!batchRecord.getRecords().isEmpty()) {
            this.batchWrite(country, batchRecord.getRecords());
        }
        MigrateResult result = new MigrateResult(batchRecord.getRecords().size(), batchRecord.getTotal() - batchRecord.getRecords().size(), batchRecord.getErrors());
        if (LOG.isTraceEnabled()) {
            LOG.trace("migrate results={}", (Object)result);
        }
        return result;
    }

    @Override
    public BatchRecord batchWrite(String country, List<Record> records) throws StorageClientException, StorageServerException, StorageCryptoException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("batchWrite params (country={} , records={})", (Object)country, (Object)BatchRecord.toString(records));
        }
        if (records == null || records.isEmpty()) {
            LOG.error(MSG_ERR_NULL_BATCH);
            throw new StorageClientException(MSG_ERR_NULL_BATCH);
        }
        for (Record record : records) {
            this.checkParameters(country, record.getRecordKey());
        }
        this.dao.createBatch(records, country, this.cryptoManager);
        return new BatchRecord(records, 0, 0, 0, 0, null);
    }

    @Override
    public boolean delete(String country, String recordKey) throws StorageClientException, StorageServerException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("delete params (country={} , key={})", (Object)country, (Object)(recordKey != null ? MSG_SIMPLE_SECURE : null));
        }
        this.checkParameters(country, recordKey);
        this.dao.delete(country, recordKey, this.cryptoManager);
        return true;
    }

    @Override
    public BatchRecord find(String country, FindFilterBuilder builder) throws StorageClientException, StorageServerException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("find params (country={} , builder={})", (Object)country, (Object)builder);
        }
        StorageImpl.checkNotNull(country, MSG_ERR_NULL_COUNTRY);
        StorageImpl.checkNotNull(builder, MSG_ERR_NULL_FILTERS);
        BatchRecord batchRecord = this.dao.find(country, builder.copy(), this.cryptoManager);
        if (LOG.isTraceEnabled()) {
            LOG.trace("find results ({})", (Object)batchRecord);
        }
        return batchRecord;
    }

    @Override
    public Record findOne(String country, FindFilterBuilder builder) throws StorageClientException, StorageServerException {
        BatchRecord findResults;
        List<Record> records;
        if (LOG.isTraceEnabled()) {
            LOG.trace("findOne params (country={} , builder={})", (Object)country, (Object)builder);
        }
        if ((records = (findResults = this.find(country, builder != null ? builder.copy().limitAndOffset(1, 0) : null)).getRecords()).isEmpty()) {
            LOG.warn(MSG_FOUND_NOTHING);
            return null;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("findOne results ({})", (Object)records.get(0).hashCode());
        }
        return records.get(0);
    }
}

