/*
 * Decompiled with CFR 0.152.
 */
package com.incountry.residence.sdk.dto.search;

import com.incountry.residence.sdk.tools.exceptions.StorageClientException;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilterNumberParam {
    private static final Logger LOG = LogManager.getLogger(FilterNumberParam.class);
    private static final String ERR_NULL_VALUE = "FilterNumberParam values can't be null";
    private static final String ERR_OPER1_RESTR = String.format("Operator1 in range filter can by only %s or %s", "$gt", "$gte");
    private static final String ERR_OPER2_RESTR = String.format("Operator2 in range filter can by only %s or %s", "$lt", "$lte");
    private static final String ERR_RANGE_RESTR = "Value1 in range filter can by only less or equals value2";
    private static final String ERR_CONDITION_RESTR = String.format("Operator in number filter can by only in [%s,%s,%s,%s,%s]", "$lt", "$lte", "$gt", "$gte", "$not");
    private final Long[] values;
    private final String operator1;
    private final String operator2;

    private FilterNumberParam(Long[] values, String operator1, String operator2) {
        this.values = Arrays.copyOf(values, values.length);
        this.operator1 = operator1;
        this.operator2 = operator2;
    }

    public FilterNumberParam(Long[] values) throws StorageClientException {
        if (values == null || values.length == 0 || Stream.of(values).anyMatch(Objects::isNull)) {
            LOG.error(ERR_NULL_VALUE);
            throw new StorageClientException(ERR_NULL_VALUE);
        }
        this.values = Arrays.copyOf(values, values.length);
        this.operator1 = null;
        this.operator2 = null;
    }

    public FilterNumberParam(String operator, Long value) throws StorageClientException {
        if (operator == null || this.notIn(operator, "$gt", "$gte", "$not", "$lt", "$lte")) {
            LOG.error(ERR_CONDITION_RESTR);
            throw new StorageClientException(ERR_CONDITION_RESTR);
        }
        if (value == null) {
            LOG.error(ERR_NULL_VALUE);
            throw new StorageClientException(ERR_NULL_VALUE);
        }
        this.values = new Long[]{value};
        this.operator1 = operator;
        this.operator2 = null;
    }

    public FilterNumberParam(String operator1, Long value1, String operator2, Long value2) throws StorageClientException {
        if (operator1 == null || this.notIn(operator1, "$gt", "$gte")) {
            LOG.error(ERR_OPER1_RESTR);
            throw new StorageClientException(ERR_OPER1_RESTR);
        }
        if (operator2 == null || !"$lt".equals(operator2) && !"$lte".equals(operator2)) {
            LOG.error(ERR_OPER2_RESTR);
            throw new StorageClientException(ERR_OPER2_RESTR);
        }
        if (value1 == null || value2 == null) {
            LOG.error(ERR_NULL_VALUE);
            throw new StorageClientException(ERR_NULL_VALUE);
        }
        if (value1 > value2) {
            LOG.error(ERR_RANGE_RESTR);
            throw new StorageClientException(ERR_RANGE_RESTR);
        }
        this.values = new Long[]{value1, value2};
        this.operator1 = operator1;
        this.operator2 = operator2;
    }

    private boolean notIn(String operator, String ... permitted) {
        for (String value : permitted) {
            if (!value.equals(operator)) continue;
            return false;
        }
        return true;
    }

    public boolean isConditional() {
        return this.operator1 != null;
    }

    public boolean isRange() {
        return this.operator2 != null && this.operator1 != null;
    }

    public Long[] getValues() {
        if (this.values != null && this.values.length > 0) {
            return Arrays.copyOf(this.values, this.values.length);
        }
        return new Long[0];
    }

    public String getOperator1() {
        return this.operator1;
    }

    public String getOperator2() {
        return this.operator2;
    }

    public FilterNumberParam copy() {
        return new FilterNumberParam(this.getValues(), this.getOperator1(), this.getOperator2());
    }

    public String toString() {
        return "FilterRangeParam{values=" + Arrays.toString((Object[])this.values) + ", operator1='" + this.operator1 + '\'' + ", operator2='" + this.operator2 + '\'' + '}';
    }
}

