/*
 * Decompiled with CFR 0.152.
 */
package com.incountry.residence.sdk.tools.crypto;

import com.incountry.residence.sdk.tools.crypto.Crypto;
import com.incountry.residence.sdk.tools.crypto.CryptoUtils;
import com.incountry.residence.sdk.tools.crypto.DefaultCrypto;
import com.incountry.residence.sdk.tools.exceptions.StorageClientException;
import com.incountry.residence.sdk.tools.exceptions.StorageCryptoException;
import com.incountry.residence.sdk.tools.exceptions.StorageException;
import com.incountry.residence.sdk.tools.keyaccessor.SecretKeyAccessor;
import com.incountry.residence.sdk.tools.keyaccessor.key.SecretKey;
import com.incountry.residence.sdk.tools.keyaccessor.key.SecretsData;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CryptoManager {
    private static final Logger LOG = LogManager.getLogger(CryptoManager.class);
    private static final String MSG_ERR_NO_SECRET = "No secret provided. Cannot decrypt record: ";
    private static final String MSG_ERR_VERSION = "Secret not found for 'version'=%d with 'isForCustomEncryption'=%b";
    private static final String MSG_ERR_DECRYPTION_FORMAT = "Unknown cipher format";
    private static final String MSG_ERR_DECRYPTION = "Unknown custom encryption version: %s";
    private static final String MSG_ERR_DECRYPTION_BASE64 = "Unexpected exception during custom decryption - failed to parse custom encryption version: %s";
    private static final String MSG_ERR_UNEXPECTED = "Unexpected exception";
    private static final String MSG_NULL_SECRET = "SecretKeyAccessor returns null secret";
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    public static final String PREFIX_PLAIN_TEXT_VERSION = "pt";
    public static final String PREFIX_CUSTOM_ENCRYPTION = "c";
    private SecretKeyAccessor keyAccessor;
    private Map<String, Crypto> customEncryptionMap;
    private Crypto currentCrypto;
    private String currentCryptoVersion;
    private final DefaultCrypto defaultCrypto = new DefaultCrypto(CHARSET);
    private String envId;
    private boolean usePTEncryption;
    private boolean normalizeKeys;

    public CryptoManager(SecretKeyAccessor keyAccessor, String envId, List<Crypto> customEncryptionList, boolean normalizeKeys) throws StorageClientException {
        this.normalizeKeys = normalizeKeys;
        this.initFields(keyAccessor, envId);
        this.initCustomEncryptionMap(customEncryptionList);
        if (!this.usePTEncryption) {
            this.getSecret(null, this.currentCrypto != null);
        }
    }

    private void initFields(SecretKeyAccessor keyAccessor, String envId) {
        this.usePTEncryption = keyAccessor == null;
        this.keyAccessor = keyAccessor;
        this.envId = envId;
    }

    private void initCustomEncryptionMap(List<Crypto> cryptoList) throws StorageClientException {
        HashMap<String, Crypto> result = new HashMap<String, Crypto>();
        if (cryptoList != null && !cryptoList.isEmpty()) {
            SecretsData secretsData = this.keyAccessor.getSecretsData();
            for (Crypto crypto : cryptoList) {
                CryptoUtils.validateCrypto(crypto, secretsData, result, CHARSET, this.currentCrypto);
                result.put(CryptoUtils.getHashedEncVersion(crypto.getVersion(), CHARSET), crypto);
                if (!crypto.isCurrent()) continue;
                this.currentCrypto = crypto;
                this.currentCryptoVersion = CryptoUtils.getHashedEncVersion(crypto.getVersion(), CHARSET);
            }
        }
        this.customEncryptionMap = result;
    }

    public Map.Entry<String, Integer> encrypt(String text) throws StorageClientException, StorageCryptoException {
        if (this.usePTEncryption) {
            return this.encryptBase64(text);
        }
        if (this.currentCrypto != null) {
            return this.encryptCustom(text);
        }
        return this.encryptDefault(text);
    }

    private Map.Entry<String, Integer> encryptBase64(String text) {
        byte[] ptEncoded = Base64.getEncoder().encode(text.getBytes(CHARSET));
        return new AbstractMap.SimpleEntry<String, Object>("pt:" + new String(ptEncoded, CHARSET), null);
    }

    private Map.Entry<String, Integer> encryptCustom(String text) throws StorageClientException, StorageCryptoException {
        SecretKey secretKey = this.getSecret(null, true);
        try {
            String cipherText = this.currentCrypto.encrypt(text, secretKey);
            String cipherTextBase64 = new String(Base64.getEncoder().encode(cipherText.getBytes(CHARSET)), CHARSET);
            return new AbstractMap.SimpleEntry<String, Integer>(this.currentCryptoVersion + ":" + cipherTextBase64, secretKey.getVersion());
        }
        catch (StorageCryptoException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.error(MSG_ERR_UNEXPECTED, (Throwable)ex);
            throw new StorageClientException(MSG_ERR_UNEXPECTED, ex);
        }
    }

    private Map.Entry<String, Integer> encryptDefault(String text) throws StorageClientException, StorageCryptoException {
        SecretKey secretKey = this.getSecret(null, false);
        String cipher = this.defaultCrypto.encrypt(text, secretKey);
        return new AbstractMap.SimpleEntry<String, Integer>(this.defaultCrypto.getVersion() + ":" + cipher, secretKey.getVersion());
    }

    private String createHash(String stringToHash) {
        return DigestUtils.sha256Hex((String)(this.normalizeKeys ? stringToHash.toLowerCase() : stringToHash));
    }

    private SecretKey getSecret(Integer version, boolean isForCustomEncryption) throws StorageClientException {
        SecretsData secretsData = this.getSecretsDataOrException();
        if (version == null) {
            version = secretsData.getCurrentVersion();
        }
        int usedVersion = version;
        Optional<SecretKey> secretKeyOptional = secretsData.getSecrets().stream().filter(secretKey -> secretKey.getVersion() == usedVersion && isForCustomEncryption == secretKey.isForCustomEncryption()).findFirst();
        if (!secretKeyOptional.isPresent()) {
            String message = String.format(MSG_ERR_VERSION, version, isForCustomEncryption);
            LOG.error(message);
            throw new StorageClientException(message);
        }
        return secretKeyOptional.get();
    }

    public Integer getCurrentSecretVersion() throws StorageClientException {
        if (this.keyAccessor != null) {
            SecretsData secretsData = this.getSecretsDataOrException();
            return secretsData.getCurrentVersion();
        }
        return null;
    }

    private SecretsData getSecretsDataOrException() throws StorageClientException {
        SecretsData result;
        try {
            result = this.keyAccessor.getSecretsData();
        }
        catch (StorageClientException clientEx) {
            throw clientEx;
        }
        catch (Exception ex) {
            throw new StorageClientException(MSG_ERR_UNEXPECTED, ex);
        }
        if (result == null) {
            throw new StorageClientException(MSG_NULL_SECRET);
        }
        return result;
    }

    public String createKeyHash(String key) {
        if (key == null) {
            return null;
        }
        String stringToHash = key + ":" + this.envId;
        return this.createHash(stringToHash);
    }

    public String decrypt(String cipherText, Integer decryptKeyVersion) throws StorageClientException, StorageCryptoException {
        if (cipherText == null || cipherText.isEmpty()) {
            return null;
        }
        String[] parts = cipherText.split(":", 2);
        if (parts[0].equals(PREFIX_PLAIN_TEXT_VERSION)) {
            return this.decryptBase64(parts[1]);
        }
        if (this.usePTEncryption) {
            String message = MSG_ERR_NO_SECRET + cipherText;
            throw new StorageCryptoException(message);
        }
        try {
            switch (parts[0]) {
                case "1": {
                    return this.decryptV1(parts[1], decryptKeyVersion);
                }
                case "2": {
                    return this.decryptV2(parts[1], decryptKeyVersion);
                }
            }
            return this.decryptCustom(parts[0], parts[1], decryptKeyVersion);
        }
        catch (StorageException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.error(MSG_ERR_UNEXPECTED, (Throwable)ex);
            throw new StorageClientException(MSG_ERR_UNEXPECTED, ex);
        }
    }

    private String decryptV1(String cipherText, Integer decryptKeyVersion) throws StorageClientException, StorageCryptoException {
        SecretKey secretKey = this.getSecret(decryptKeyVersion, false);
        return this.defaultCrypto.decryptV1(cipherText, secretKey);
    }

    private String decryptV2(String cipherText, Integer decryptKeyVersion) throws StorageClientException, StorageCryptoException {
        SecretKey secretKey = this.getSecret(decryptKeyVersion, false);
        return this.defaultCrypto.decrypt(cipherText, secretKey);
    }

    private String decryptCustom(String decryptVersion, String cipherText, Integer decryptKeyVersion) throws StorageCryptoException, StorageClientException {
        if (!decryptVersion.startsWith(PREFIX_CUSTOM_ENCRYPTION)) {
            throw new StorageCryptoException(MSG_ERR_DECRYPTION_FORMAT);
        }
        Crypto crypto = this.customEncryptionMap.get(decryptVersion);
        if (crypto == null) {
            try {
                String version = new String(Base64.getDecoder().decode(decryptVersion.substring(1).getBytes(CHARSET)), CHARSET);
                String message = String.format(MSG_ERR_DECRYPTION, version);
                throw new StorageCryptoException(message);
            }
            catch (IllegalArgumentException iex) {
                String message = String.format(MSG_ERR_DECRYPTION_BASE64, decryptVersion.substring(1));
                throw new StorageCryptoException(message, iex);
            }
        }
        try {
            return crypto.decrypt(this.decryptBase64(cipherText), this.getSecret(decryptKeyVersion, true));
        }
        catch (StorageCryptoException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.error(MSG_ERR_UNEXPECTED, (Throwable)ex);
            throw new StorageClientException(MSG_ERR_UNEXPECTED, ex);
        }
    }

    private String decryptBase64(String cipherText) {
        byte[] decodedBytes = Base64.getDecoder().decode(cipherText);
        return new String(decodedBytes, CHARSET);
    }

    public boolean isUsePTEncryption() {
        return this.usePTEncryption;
    }
}

