/*
 * Decompiled with CFR 0.152.
 */
package com.incountry.residence.sdk.tools.dao.impl;

import com.incountry.residence.sdk.dto.BatchRecord;
import com.incountry.residence.sdk.dto.Record;
import com.incountry.residence.sdk.dto.search.FindFilterBuilder;
import com.incountry.residence.sdk.tools.JsonUtils;
import com.incountry.residence.sdk.tools.crypto.CryptoManager;
import com.incountry.residence.sdk.tools.dao.Dao;
import com.incountry.residence.sdk.tools.dao.POP;
import com.incountry.residence.sdk.tools.dao.impl.ApiResponse;
import com.incountry.residence.sdk.tools.exceptions.StorageClientException;
import com.incountry.residence.sdk.tools.exceptions.StorageCryptoException;
import com.incountry.residence.sdk.tools.exceptions.StorageException;
import com.incountry.residence.sdk.tools.exceptions.StorageServerException;
import com.incountry.residence.sdk.tools.http.HttpAgent;
import com.incountry.residence.sdk.tools.http.TokenClient;
import com.incountry.residence.sdk.tools.http.impl.HttpAgentImpl;
import com.incountry.residence.sdk.tools.proxy.ProxyUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpDaoImpl
implements Dao {
    private static final Logger LOG = LogManager.getLogger(HttpDaoImpl.class);
    private static final String DEFAULT_ENDPOINT = "https://us-mt-01.api.incountry.io";
    private static final int RETRY_CNT = 1;
    private static final String DEFAULT_COUNTRY_ENDPOINT = "https://portal-backend.incountry.com/countries";
    private static final String DEFAULT_ENDPOINT_MASK = "-mt-01.api.incountry.io";
    private static final String DEFAULT_COUNTRY = "us";
    private static final String DEFAULT_REGION = "emea";
    private static final String STORAGE_URL = "/v2/storage/records/";
    private static final String URI_HTTPS = "https://";
    private static final String URI_POST = "POST";
    private static final String URI_GET = "GET";
    private static final String URI_DELETE = "DELETE";
    private static final String URI_FIND = "/find";
    private static final String URI_BATCH_WRITE = "/batchWrite";
    private static final String URI_DELIMITER = "/";
    private static final long DEFAULT_UPDATE_INTERVAL = 300000L;
    private static final String MSG_ERR_LOAD_COUNTRIES = "Error during country list loading";
    private static final String MSG_ERR_COUNTRIES_ARE_EMPTY = "Country list is empty";
    private Map<String, POP> popMap = new ConcurrentHashMap<String, POP>();
    private final HttpAgent httpAgent;
    private final String endPointUrl;
    private final String endPointMask;
    private final boolean isDefaultEndpoint;
    private final String countriesEndpoint;
    private final AtomicLong lastLoadedTime = new AtomicLong(0L);

    public HttpDaoImpl(String environmentId, String endPoint, String endpointMask, String countriesEndpoint, TokenClient tokenClient, CloseableHttpClient httpClient) {
        this(endPoint, endpointMask, countriesEndpoint, (HttpAgent)ProxyUtils.createLoggingProxyForPublicMethods(new HttpAgentImpl((TokenClient)ProxyUtils.createLoggingProxyForPublicMethods(tokenClient), environmentId, httpClient)));
    }

    public HttpDaoImpl(String endPoint, String endpointMask, String countriesEndpoint, HttpAgent agent) {
        this.isDefaultEndpoint = endPoint == null;
        this.endPointUrl = this.isDefaultEndpoint ? DEFAULT_ENDPOINT : endPoint;
        this.countriesEndpoint = countriesEndpoint == null ? DEFAULT_COUNTRY_ENDPOINT : countriesEndpoint;
        this.endPointMask = endpointMask;
        this.httpAgent = agent;
        if (this.isDefaultEndpoint) {
            this.loadCountries();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCountries() {
        if (System.currentTimeMillis() - this.lastLoadedTime.get() < 300000L) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Start loading country list");
        }
        AtomicLong atomicLong = this.lastLoadedTime;
        synchronized (atomicLong) {
            if (System.currentTimeMillis() - this.lastLoadedTime.get() < 300000L) {
                return;
            }
            try {
                String content = this.httpAgent.request(this.countriesEndpoint, URI_GET, null, ApiResponse.COUNTRY, null, null, 1);
                ConcurrentHashMap<String, POP> newCountryMap = new ConcurrentHashMap<String, POP>(JsonUtils.getMidiPops(content, URI_HTTPS, this.endPointMask != null ? this.endPointMask : DEFAULT_ENDPOINT_MASK));
                if (newCountryMap.size() > 0) {
                    this.popMap = newCountryMap;
                }
            }
            catch (StorageException ex) {
                LOG.error(MSG_ERR_LOAD_COUNTRIES, (Throwable)ex);
            }
            this.lastLoadedTime.set(System.currentTimeMillis());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loaded country list: {}", this.popMap.keySet());
        }
    }

    private EndPoint getEndpoint(String country) throws StorageServerException {
        if (this.isDefaultEndpoint) {
            POP pop = this.getMidPop(country);
            if (pop != null) {
                return new EndPoint(pop.getHost(), pop.getHost(), pop.getRegion(DEFAULT_REGION));
            }
            String mainUrl = "https://us" + (this.endPointMask == null ? DEFAULT_ENDPOINT_MASK : this.endPointMask);
            return new EndPoint(mainUrl, this.getAudienceForMiniPop(mainUrl, country), DEFAULT_REGION);
        }
        return new EndPoint(this.endPointUrl, this.getAudienceForMiniPop(this.endPointUrl, country), DEFAULT_REGION);
    }

    private POP getMidPop(String country) throws StorageServerException {
        this.loadCountries();
        Map<String, POP> tempMap = this.popMap;
        if (this.popMap.isEmpty()) {
            throw new StorageServerException(MSG_ERR_COUNTRIES_ARE_EMPTY);
        }
        return tempMap.get(country);
    }

    private String getAudienceForMiniPop(String mainUrl, String country) {
        String mask = this.endPointMask;
        if (this.isDefaultEndpoint && mask == null) {
            mask = DEFAULT_ENDPOINT_MASK;
        }
        if (mask == null) {
            return mainUrl;
        }
        String secondaryUrl = URI_HTTPS + country + mask;
        String resultAudience = mainUrl;
        if (!mainUrl.equals(secondaryUrl)) {
            resultAudience = resultAudience + " " + secondaryUrl;
        }
        return resultAudience;
    }

    @Override
    public void createRecord(String country, Record record, CryptoManager cryptoManager) throws StorageClientException, StorageCryptoException, StorageServerException {
        String lowerCountry = country.toLowerCase();
        EndPoint endPoint = this.getEndpoint(lowerCountry);
        String url = this.getRecordActionUrl(endPoint.mainUrl, lowerCountry, new String[0]);
        String body = JsonUtils.toJsonString(record, cryptoManager);
        this.httpAgent.request(url, URI_POST, body, ApiResponse.WRITE, endPoint.audience, endPoint.region, 1);
    }

    @Override
    public void createBatch(List<Record> records, String country, CryptoManager cryptoManager) throws StorageClientException, StorageServerException, StorageCryptoException {
        String lowerCountry = country.toLowerCase();
        String recListJson = JsonUtils.toJsonString(records, cryptoManager);
        EndPoint endPoint = this.getEndpoint(lowerCountry);
        String url = this.getRecordActionUrl(endPoint.mainUrl, lowerCountry, URI_BATCH_WRITE);
        this.httpAgent.request(url, URI_POST, recListJson, ApiResponse.BATCH_WRITE, endPoint.audience, endPoint.region, 1);
    }

    @Override
    public Record read(String country, String recordKey, CryptoManager cryptoManager) throws StorageClientException, StorageServerException, StorageCryptoException {
        String lowerCountry = country.toLowerCase();
        String key = cryptoManager != null ? cryptoManager.createKeyHash(recordKey) : recordKey;
        EndPoint endPoint = this.getEndpoint(lowerCountry);
        String url = this.getRecordUrl(endPoint.mainUrl, lowerCountry, key);
        String response = this.httpAgent.request(url, URI_GET, null, ApiResponse.READ, endPoint.audience, endPoint.region, 1);
        if (response == null) {
            return null;
        }
        return JsonUtils.recordFromString(response, cryptoManager);
    }

    @Override
    public void delete(String country, String key, CryptoManager cryptoManager) throws StorageServerException, StorageClientException {
        String lowerCountry = country.toLowerCase();
        String recordHash = cryptoManager != null ? cryptoManager.createKeyHash(key) : key;
        EndPoint endPoint = this.getEndpoint(lowerCountry);
        String url = this.getRecordUrl(endPoint.mainUrl, lowerCountry, recordHash);
        this.httpAgent.request(url, URI_DELETE, null, ApiResponse.DELETE, endPoint.audience, endPoint.region, 1);
    }

    @Override
    public BatchRecord find(String country, FindFilterBuilder builder, CryptoManager cryptoManager) throws StorageClientException, StorageServerException {
        String postData;
        String lowerCountry = country.toLowerCase();
        EndPoint endpoint = this.getEndpoint(lowerCountry);
        String url = this.getRecordActionUrl(endpoint.mainUrl, lowerCountry, URI_FIND);
        String content = this.httpAgent.request(url, URI_POST, postData = JsonUtils.toJsonString(builder.build(), cryptoManager), ApiResponse.FIND, endpoint.audience, endpoint.region, 1);
        if (content == null) {
            return new BatchRecord(new ArrayList<Record>(), 0, 0, 0, 0, null);
        }
        return JsonUtils.batchRecordFromString(content, cryptoManager);
    }

    private String getRecordUrl(String endPoint, String country, String keyHash) {
        return endPoint + STORAGE_URL + country + URI_DELIMITER + keyHash;
    }

    private String getRecordActionUrl(String endpoint, String country, String ... other) {
        StringBuilder builder = new StringBuilder(endpoint).append(STORAGE_URL);
        builder.append(country);
        for (String part : other) {
            builder.append(part);
        }
        return builder.toString();
    }

    private static class EndPoint {
        String mainUrl;
        String audience;
        String region;

        EndPoint(String mainUrl, String audience, String region) {
            this.mainUrl = mainUrl;
            this.audience = audience;
            this.region = region;
        }
    }
}

