/*
 * Decompiled with CFR 0.152.
 */
package com.incountry.residence.sdk.tools.http.impl;

import com.incountry.residence.sdk.tools.dao.impl.ApiResponse;
import com.incountry.residence.sdk.tools.exceptions.StorageClientException;
import com.incountry.residence.sdk.tools.exceptions.StorageServerException;
import com.incountry.residence.sdk.tools.http.HttpAgent;
import com.incountry.residence.sdk.tools.http.TokenClient;
import com.incountry.residence.sdk.tools.http.impl.AbstractHttpRequestCreator;
import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpAgentImpl
extends AbstractHttpRequestCreator
implements HttpAgent {
    private static final Logger LOG = LogManager.getLogger(HttpAgentImpl.class);
    private static final String MSG_SERVER_ERROR = "Server request error: [URL=%s, method=%s]";
    private static final String MSG_URL_NULL_ERR = "URL can't be null";
    private static final String MSG_ERR_CONTENT = "Code=%d, endpoint=[%s], content=[%s]";
    private static final String BEARER = "Bearer ";
    private static final String AUTHORIZATION = "Authorization";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String ENV_ID = "x-env-id";
    private static final String USER_AGENT = "User-Agent";
    private static final String APPLICATION_JSON = "application/json";
    private final TokenClient tokenClient;
    private final String environmentId;
    private final String userAgent;
    private final CloseableHttpClient httpClient;

    public HttpAgentImpl(TokenClient tokenClient, String environmentId, CloseableHttpClient httpClient) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HttpAgentImpl constructor params (tokenClient={} , environmentId={})", (Object)tokenClient, environmentId != null ? "[SECURE[" + environmentId.hashCode() + "]]" : null);
        }
        this.tokenClient = tokenClient;
        this.environmentId = environmentId;
        this.userAgent = "SDK-Java/3.0.0";
        this.httpClient = httpClient;
    }

    @Override
    public String request(String url, String method, String body, Map<Integer, ApiResponse> codeMap, String audience, String region, int retryCount) throws StorageServerException, StorageClientException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("HTTP request params (url={} , method={} , codeMap={})", (Object)url, (Object)method, codeMap);
        }
        if (url == null) {
            throw new StorageClientException(MSG_URL_NULL_ERR);
        }
        try {
            boolean isFinish;
            HttpRequestBase request = this.createRequest(url, method, body);
            this.addHeaders(request, audience, region);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            int status = response.getStatusLine().getStatusCode();
            String actualResponseContent = EntityUtils.toString((HttpEntity)response.getEntity());
            response.close();
            ApiResponse expectedResponse = codeMap.get(status);
            boolean isSuccess = expectedResponse != null && !expectedResponse.isError() && !actualResponseContent.isEmpty();
            boolean bl = isFinish = isSuccess || expectedResponse == null || !this.canRetry(expectedResponse, retryCount);
            if (!isFinish) {
                this.tokenClient.refreshToken(true, audience, region);
                return this.request(url, method, body, codeMap, audience, region, retryCount - 1);
            }
            if (expectedResponse != null && expectedResponse.isIgnored()) {
                return null;
            }
            if (expectedResponse == null || expectedResponse.isError()) {
                String errorMessage = String.format(MSG_ERR_CONTENT, status, url, actualResponseContent).replaceAll("[\r\n]", "");
                LOG.error(errorMessage);
                throw new StorageServerException(errorMessage);
            }
            return actualResponseContent;
        }
        catch (IOException ex) {
            String errorMessage = String.format(MSG_SERVER_ERROR, url, method);
            throw new StorageServerException(errorMessage, ex);
        }
    }

    private HttpRequestBase addHeaders(HttpRequestBase request, String audience, String region) throws StorageServerException {
        if (audience != null) {
            request.addHeader(AUTHORIZATION, BEARER + this.tokenClient.getToken(audience, region));
        }
        request.addHeader(CONTENT_TYPE, APPLICATION_JSON);
        request.addHeader(ENV_ID, this.environmentId);
        request.addHeader(USER_AGENT, this.userAgent);
        return request;
    }

    private boolean canRetry(ApiResponse params, int retryCount) {
        return params.isCanRetry() && retryCount > 0;
    }
}

