/*
 * Decompiled with CFR 0.152.
 */
package com.incountry.residence.sdk.tools.http.impl;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.incountry.residence.sdk.tools.exceptions.StorageClientException;
import com.incountry.residence.sdk.tools.exceptions.StorageServerException;
import com.incountry.residence.sdk.tools.http.TokenClient;
import com.incountry.residence.sdk.tools.http.impl.AbstractHttpRequestCreator;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OAuthTokenClient
extends AbstractHttpRequestCreator
implements TokenClient {
    private static final Logger LOG = LogManager.getLogger(OAuthTokenClient.class);
    private static final String MSG_REFRESH_TOKEN = "refreshToken force={}, audience={}";
    private static final String MSG_AUTH_URL = "auth URL={}";
    private static final String DEFAULT_APAC_AUTH_URL = "https://auth-apac.incountry.com/oauth2/token";
    private static final String DEFAULT_EMEA_AUTH_URL = "https://auth-emea.incountry.com/oauth2/token";
    private static final String APAC = "apac";
    private static final String EMEA = "emea";
    private static final String MSG_ERR_AUTH = "Unexpected exception during authorization, params [OAuth URL=%s, audience=%s]";
    private static final String MSG_ERR_NULL_TOKEN = "Token is null";
    private static final String MSG_ERR_EXPIRES = "Token TTL is invalid";
    private static final String MSG_ERR_INVALID_TYPE = "Token type is invalid";
    private static final String MSG_ERR_INVALID_SCOPE = "Token scope is invalid";
    private static final String MSG_RESPONSE_ERR = "Error in parsing authorization response: '%s'";
    private static final String MSG_ERR_PARAMS = "Can't use param 'authEndpoints' without setting 'defaultAuthEndpoint'";
    private static final String MSG_ERR_ILLEGAL_AUTH_ENDPOINTS = "Parameter 'authEndpoints' contains null keys/values";
    private static final String USER_AGENT = "User-Agent";
    private static final String USER_AGENT_VALUE = "SDK-Java/3.0.0";
    private static final String BODY = "grant_type=client_credentials&audience=%s&scope=%s";
    private static final String BEARER_TOKEN_TYPE = "bearer";
    private static final String BASIC = "Basic ";
    private static final String POST = "POST";
    private static final String AUTHORIZATION = "Authorization";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final String APPLICATION_URLENCODED = "application/x-www-form-urlencoded";
    private final String basicAuthToken;
    private final String scope;
    private final Map<String, Map.Entry<String, Long>> tokenMap = new HashMap<String, Map.Entry<String, Long>>();
    private final Map<String, String> regionMap = new HashMap<String, String>();
    private final String defaultAuthEndpoint;
    private final CloseableHttpClient httpClient;

    public OAuthTokenClient(String defaultAuthEndpoint, Map<String, String> authEndpointMap, String scope, String clientId, String secret, CloseableHttpClient httpClient) throws StorageClientException {
        if (authEndpointMap != null && !authEndpointMap.isEmpty()) {
            if (this.isEmpty(defaultAuthEndpoint)) {
                throw new StorageClientException(MSG_ERR_PARAMS);
            }
            if (authEndpointMap.entrySet().stream().anyMatch(entry -> this.isEmpty((String)entry.getKey()) || this.isEmpty((String)entry.getValue()))) {
                throw new StorageClientException(MSG_ERR_ILLEGAL_AUTH_ENDPOINTS);
            }
        }
        this.scope = scope;
        this.basicAuthToken = BASIC + this.getCredentialsBase64(clientId, secret);
        this.httpClient = httpClient;
        String string = this.defaultAuthEndpoint = defaultAuthEndpoint != null ? defaultAuthEndpoint : DEFAULT_EMEA_AUTH_URL;
        if (authEndpointMap == null || authEndpointMap.isEmpty()) {
            if (defaultAuthEndpoint == null) {
                this.regionMap.put(APAC, DEFAULT_APAC_AUTH_URL);
                this.regionMap.put(EMEA, DEFAULT_EMEA_AUTH_URL);
            }
        } else {
            authEndpointMap.forEach((key, value) -> this.regionMap.put(key.toLowerCase(), (String)value));
        }
    }

    private boolean isEmpty(String row) {
        return row == null || row.isEmpty();
    }

    @Override
    public String getToken(String audience, String region) throws StorageServerException {
        return this.refreshToken(false, audience, region);
    }

    @Override
    public synchronized String refreshToken(boolean force, String audience, String region) throws StorageServerException {
        if (LOG.isTraceEnabled()) {
            LOG.trace(MSG_REFRESH_TOKEN, (Object)force, (Object)audience);
        }
        Map.Entry<String, Long> token = this.tokenMap.get(audience);
        if (force || token == null || token.getValue() < System.currentTimeMillis()) {
            token = this.newToken(audience, region);
            this.tokenMap.put(audience, token);
        }
        return token.getKey();
    }

    private HttpRequestBase addHeaders(HttpRequestBase request) {
        request.addHeader(AUTHORIZATION, this.basicAuthToken);
        request.addHeader(CONTENT_TYPE, APPLICATION_URLENCODED);
        request.addHeader(USER_AGENT, USER_AGENT_VALUE);
        return request;
    }

    private Map.Entry<String, Long> newToken(String audience, String region) throws StorageServerException {
        String body = String.format(BODY, audience, this.scope);
        String authUrl = null;
        try {
            boolean isSuccess;
            authUrl = this.regionMap.get(region);
            if (authUrl == null) {
                authUrl = this.defaultAuthEndpoint;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace(MSG_AUTH_URL, (Object)authUrl);
            }
            HttpRequestBase request = this.createRequest(authUrl, POST, body);
            this.addHeaders(request);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            int status = response.getStatusLine().getStatusCode();
            String responseContent = EntityUtils.toString((HttpEntity)response.getEntity());
            response.close();
            boolean bl = isSuccess = status == 200;
            if (!isSuccess) {
                throw this.createAndLogException(String.format(MSG_RESPONSE_ERR, responseContent));
            }
            return this.validateAndGet(responseContent);
        }
        catch (StorageServerException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String errorMessage = String.format(MSG_ERR_AUTH, authUrl, audience);
            LOG.error(errorMessage);
            throw new StorageServerException(errorMessage, ex);
        }
    }

    private Map.Entry<String, Long> validateAndGet(String response) throws StorageServerException {
        try {
            TransferToken token = (TransferToken)new GsonBuilder().setFieldNamingStrategy((FieldNamingStrategy)FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create().fromJson(response, TransferToken.class);
            if (token.accessToken == null || token.accessToken.isEmpty()) {
                throw this.createAndLogException(MSG_ERR_NULL_TOKEN);
            }
            if (token.expiresIn == null || token.expiresIn < 1L) {
                throw this.createAndLogException(MSG_ERR_EXPIRES);
            }
            if (!BEARER_TOKEN_TYPE.equals(token.tokenType)) {
                throw this.createAndLogException(MSG_ERR_INVALID_TYPE);
            }
            if (!this.scope.equals(token.scope)) {
                throw this.createAndLogException(MSG_ERR_INVALID_SCOPE);
            }
            return new AbstractMap.SimpleEntry<String, Long>(token.accessToken, System.currentTimeMillis() + token.expiresIn * 1000L);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            String errorMessage = String.format(MSG_RESPONSE_ERR, response);
            LOG.error(errorMessage);
            throw new StorageServerException(errorMessage, jsonSyntaxException);
        }
    }

    private StorageServerException createAndLogException(String message) {
        message = message.replaceAll("[\r\n]", "");
        LOG.error(message);
        return new StorageServerException(message);
    }

    private String getCredentialsBase64(String clientId, String secret) {
        return new String(Base64.getEncoder().encode((clientId + ":" + secret).getBytes(CHARSET)), CHARSET);
    }

    private static class TransferToken {
        String accessToken;
        String tokenType;
        String scope;
        Long expiresIn;

        private TransferToken() {
        }
    }
}

