/*
 * Decompiled with CFR 0.152.
 */
package com.incountry.residence.sdk.tools.keyaccessor.key;

import com.incountry.residence.sdk.tools.exceptions.StorageClientException;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SecretKey {
    private static final Logger LOG = LogManager.getLogger(SecretKey.class);
    private static final int KEY_LENGTH = 32;
    private static final String MSG_ERR_VERSION = "Version must be >= 0";
    private static final String MSG_ERR_NULL_SECRET = "Secret can't be null";
    private static final String MSG_ERR_OPTION = "SecretKey can have either 'isKey' or 'isForCustomEncryption' set to True, not both";
    private static final String MSG_ERR_KEY_LEN = "Wrong key length for secret key with 'isKey==true'. Should be 32 characters \u2018utf8\u2019";
    private final byte[] secret;
    private final int version;
    private final boolean isKey;
    private final boolean isForCustomEncryption;

    public SecretKey(byte[] secret, int version, boolean isKey) throws StorageClientException {
        SecretKey.validateSecretKey(secret, version, isKey, false);
        this.version = version;
        this.secret = Arrays.copyOf(secret, secret.length);
        this.isKey = isKey;
        this.isForCustomEncryption = false;
    }

    public SecretKey(byte[] secret, int version, boolean isKey, boolean isForCustomEncryption) throws StorageClientException {
        SecretKey.validateSecretKey(secret, version, isKey, isForCustomEncryption);
        this.version = version;
        this.secret = Arrays.copyOf(secret, secret.length);
        this.isKey = isKey;
        this.isForCustomEncryption = isForCustomEncryption;
    }

    public byte[] getSecret() {
        return Arrays.copyOf(this.secret, this.secret.length);
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isKey() {
        return this.isKey;
    }

    public boolean isForCustomEncryption() {
        return this.isForCustomEncryption;
    }

    public static void validateSecretKey(byte[] secret, int version, boolean isKey, boolean isForCustomEncryption) throws StorageClientException {
        if (version < 0) {
            LOG.error(MSG_ERR_VERSION);
            throw new StorageClientException(MSG_ERR_VERSION);
        }
        if (secret == null || secret.length == 0) {
            LOG.error(MSG_ERR_NULL_SECRET);
            throw new StorageClientException(MSG_ERR_NULL_SECRET);
        }
        if (isKey && secret.length != 32) {
            LOG.error(MSG_ERR_KEY_LEN);
            throw new StorageClientException(MSG_ERR_KEY_LEN);
        }
        if (isKey && isForCustomEncryption) {
            LOG.error(MSG_ERR_OPTION);
            throw new StorageClientException(MSG_ERR_OPTION);
        }
    }

    public String toString() {
        return "SecretKey{secret=HASH[" + Arrays.hashCode(this.secret) + ']' + ", version=" + this.version + ", isKey=" + this.isKey + ", isForCustomEncryption=" + this.isForCustomEncryption + '}';
    }
}

