/*
 * Decompiled with CFR 0.152.
 */
package com.incountry.residence.sdk.tools.keyaccessor.key;

import com.incountry.residence.sdk.tools.exceptions.StorageClientException;
import com.incountry.residence.sdk.tools.keyaccessor.key.SecretKey;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SecretsData {
    private static final Logger LOG = LogManager.getLogger(SecretsData.class);
    private static final String MSG_ERR_VERSION = "Current version must be >= 0";
    private static final String MSG_ERR_EMPTY_SECRETS = "Secrets in SecretData are null";
    private static final String MSG_ERR_UNIQUE_VERSIONS = "SecretKey versions must be unique. Got duplicates for: %s";
    private static final String MSG_ERR_CURRENT_VERSION = "There is no SecretKey version that matches current version %d";
    private List<SecretKey> secrets;
    private int currentVersion;

    public SecretsData(List<SecretKey> secrets, int currentVersion) throws StorageClientException {
        SecretsData.validate(secrets, currentVersion);
        this.currentVersion = currentVersion;
        this.secrets = secrets;
    }

    public List<SecretKey> getSecrets() {
        return this.secrets;
    }

    public int getCurrentVersion() {
        return this.currentVersion;
    }

    private static void validate(List<SecretKey> secrets, int currentVersion) throws StorageClientException {
        if (secrets == null || secrets.isEmpty()) {
            LOG.error(MSG_ERR_EMPTY_SECRETS);
            throw new StorageClientException(MSG_ERR_EMPTY_SECRETS);
        }
        if (currentVersion < 0) {
            LOG.error(MSG_ERR_VERSION);
            throw new StorageClientException(MSG_ERR_VERSION);
        }
        ArrayList<Integer> errorList = new ArrayList<Integer>();
        HashSet<Integer> versionSet = new HashSet<Integer>();
        for (SecretKey secretKey : secrets) {
            SecretKey.validateSecretKey(secretKey.getSecret(), secretKey.getVersion(), secretKey.isKey(), secretKey.isForCustomEncryption());
            if (versionSet.contains(secretKey.getVersion())) {
                errorList.add(secretKey.getVersion());
            } else {
                versionSet.add(secretKey.getVersion());
            }
            if (errorList.isEmpty()) continue;
            String message = String.format(MSG_ERR_UNIQUE_VERSIONS, ((Object)errorList).toString());
            LOG.error(message);
            throw new StorageClientException(message);
        }
        if (!versionSet.contains(currentVersion)) {
            String message = String.format(MSG_ERR_CURRENT_VERSION, currentVersion);
            LOG.error(message);
            throw new StorageClientException(message);
        }
    }

    public String toString() {
        return "SecretsData{secrets=" + this.secrets + ", currentVersion=" + this.currentVersion + '}';
    }
}

