/*
 * Decompiled with CFR 0.152.
 */
package com.incountry.residence.sdk.tools.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProxyUtils {
    private ProxyUtils() {
    }

    public static <T, R> R createLoggingProxyForPublicMethods(T object) {
        Logger log = LogManager.getLogger(object.getClass());
        InvocationHandler handler = (proxy, method, args) -> {
            Object result;
            long currentTime = 0L;
            if (log.isDebugEnabled()) {
                currentTime = System.currentTimeMillis();
                log.debug("{} start", (Object)method.getName());
            }
            try {
                result = method.invoke(object, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
            finally {
                if (log.isDebugEnabled()) {
                    currentTime = System.currentTimeMillis() - currentTime;
                    log.debug("{} finish, latency in ms={}", (Object)method.getName(), (Object)currentTime);
                }
            }
            return result;
        };
        return (R)Proxy.newProxyInstance(object.getClass().getClassLoader(), object.getClass().getInterfaces(), handler);
    }
}

