/*
 * Decompiled with CFR 0.152.
 */
package com.incountry.residence.sdk.tools.transfer;

import com.incountry.residence.sdk.dto.BatchRecord;
import com.incountry.residence.sdk.tools.exceptions.StorageServerException;
import com.incountry.residence.sdk.tools.transfer.TransferRecord;
import java.util.List;

public class TransferBatch {
    private static final String MSG_ERR_NULL_META = "Response error: Meta is null";
    private static final String MSG_ERR_NEGATIVE_META = "Response error: negative values in batch metadata";
    private static final String MSG_ERR_INCORRECT_COUNT = "Response error: count in batch metadata differs from data size";
    private static final String MSG_ERR_INCORRECT_TOTAL = "Response error: incorrect total in batch metadata, less then received";
    BatchRecord meta;
    List<TransferRecord> data;

    public void validate() throws StorageServerException {
        boolean zeroMetaNonEmptyData;
        if (this.meta == null) {
            throw new StorageServerException(MSG_ERR_NULL_META);
        }
        boolean negativeNumber = this.meta.getCount() < 0 || this.meta.getLimit() < 0 || this.meta.getOffset() < 0 || this.meta.getTotal() < 0;
        boolean positiveMetaEmptyData = this.meta.getCount() > 0 && (this.data == null || this.data.isEmpty() || this.data.size() != this.meta.getCount());
        boolean bl = zeroMetaNonEmptyData = this.meta.getCount() == 0 && this.data != null && !this.data.isEmpty();
        if (negativeNumber) {
            throw new StorageServerException(MSG_ERR_NEGATIVE_META);
        }
        if (positiveMetaEmptyData || zeroMetaNonEmptyData) {
            throw new StorageServerException(MSG_ERR_INCORRECT_COUNT);
        }
        if (this.meta.getCount() > this.meta.getTotal()) {
            throw new StorageServerException(MSG_ERR_INCORRECT_TOTAL);
        }
    }

    public BatchRecord getMeta() {
        return this.meta;
    }

    public void setMeta(BatchRecord meta) {
        this.meta = meta;
    }

    public List<TransferRecord> getData() {
        return this.data;
    }

    public void setData(List<TransferRecord> data) {
        this.data = data;
    }
}

