/*
 * Decompiled with CFR 0.152.
 */
package com.incountry.residence.sdk.tools.transfer;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.incountry.residence.sdk.dto.Record;
import com.incountry.residence.sdk.tools.crypto.CryptoManager;
import com.incountry.residence.sdk.tools.exceptions.StorageClientException;
import com.incountry.residence.sdk.tools.exceptions.StorageCryptoException;
import com.incountry.residence.sdk.tools.exceptions.StorageServerException;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransferRecord
extends Record {
    private static final Logger LOG = LogManager.getLogger(TransferRecord.class);
    private static final String P_PAYLOAD = "payload";
    private static final String P_META = "meta";
    private static final String MSG_ERR_RESPONSE = "Response error";
    private String key;
    private Integer version;
    private boolean isEncrypted;

    public TransferRecord(Record record, CryptoManager cryptoManager, String bodyJsonString) throws StorageClientException, StorageCryptoException {
        super(cryptoManager.createKeyHash(record.getRecordKey()));
        this.setKey1(cryptoManager.createKeyHash(record.getKey1()));
        this.setKey2(cryptoManager.createKeyHash(record.getKey2()));
        this.setKey3(cryptoManager.createKeyHash(record.getKey3()));
        this.setKey4(cryptoManager.createKeyHash(record.getKey4()));
        this.setKey5(cryptoManager.createKeyHash(record.getKey5()));
        this.setKey6(cryptoManager.createKeyHash(record.getKey6()));
        this.setKey7(cryptoManager.createKeyHash(record.getKey7()));
        this.setKey8(cryptoManager.createKeyHash(record.getKey8()));
        this.setKey9(cryptoManager.createKeyHash(record.getKey9()));
        this.setKey10(cryptoManager.createKeyHash(record.getKey10()));
        this.setProfileKey(cryptoManager.createKeyHash(record.getProfileKey()));
        this.setServiceKey1(cryptoManager.createKeyHash(record.getServiceKey1()));
        this.setServiceKey2(cryptoManager.createKeyHash(record.getServiceKey2()));
        this.setRangeKey1(record.getRangeKey1());
        this.setRangeKey2(record.getRangeKey2());
        this.setRangeKey3(record.getRangeKey3());
        this.setRangeKey4(record.getRangeKey4());
        this.setRangeKey5(record.getRangeKey5());
        this.setRangeKey6(record.getRangeKey6());
        this.setRangeKey7(record.getRangeKey7());
        this.setRangeKey8(record.getRangeKey8());
        this.setRangeKey9(record.getRangeKey9());
        this.setRangeKey10(record.getRangeKey10());
        Map.Entry<String, Integer> encBodyAndVersion = cryptoManager.encrypt(bodyJsonString);
        this.setBody(encBodyAndVersion.getKey());
        this.isEncrypted = !cryptoManager.isUsePTEncryption();
        this.version = encBodyAndVersion.getValue() != null ? encBodyAndVersion.getValue() : 0;
        if (record.getPrecommitBody() != null) {
            Map.Entry<String, Integer> encPreCommit = cryptoManager.encrypt(record.getPrecommitBody());
            this.setPrecommitBody(encPreCommit.getKey());
        }
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public void setEncrypted(boolean encrypted) {
        this.isEncrypted = encrypted;
    }

    public static void validate(TransferRecord record) throws StorageServerException {
        StringBuilder builder = null;
        if (record == null) {
            builder = new StringBuilder("Received record is null");
        } else {
            if (record.getRecordKey() == null || record.getRecordKey().length() == 0) {
                builder = new StringBuilder("Null required record fields: recordKey");
            }
            if (record.getBody() == null || record.getBody().length() == 0) {
                StringBuilder stringBuilder = builder = builder == null ? new StringBuilder("Null required record fields: body") : builder.append(", body");
            }
        }
        if (builder != null) {
            String message = builder.toString();
            LOG.error(message);
            throw new StorageServerException(message);
        }
    }

    public void decryptAllFromBody(Gson gson) {
        JsonObject bodyObj = (JsonObject)gson.fromJson(this.getBody(), JsonObject.class);
        JsonElement innerBodyJson = bodyObj.get(P_PAYLOAD);
        this.setBody(innerBodyJson != null ? innerBodyJson.getAsString() : null);
        TransferRecord recordFromMeta = (TransferRecord)gson.fromJson(bodyObj.get(P_META), TransferRecord.class);
        String recordKey = recordFromMeta.getRecordKey();
        if (recordKey == null && recordFromMeta.key != null) {
            recordKey = recordFromMeta.key;
        }
        this.setRecordKey(recordKey);
        this.setKey1(recordFromMeta.getKey1());
        this.setKey2(recordFromMeta.getKey2());
        this.setKey3(recordFromMeta.getKey3());
        this.setKey4(recordFromMeta.getKey4());
        this.setKey5(recordFromMeta.getKey5());
        this.setKey6(recordFromMeta.getKey6());
        this.setKey7(recordFromMeta.getKey7());
        this.setKey8(recordFromMeta.getKey8());
        this.setKey9(recordFromMeta.getKey9());
        this.setKey10(recordFromMeta.getKey10());
        this.setProfileKey(recordFromMeta.getProfileKey());
        this.setServiceKey1(recordFromMeta.getServiceKey1());
        this.setServiceKey2(recordFromMeta.getServiceKey2());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        TransferRecord that = (TransferRecord)object;
        return Objects.equals(this.version, that.version);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.version);
    }

    public Record decrypt(CryptoManager cryptoManager, Gson gson) throws StorageClientException, StorageCryptoException, StorageServerException {
        try {
            if (cryptoManager != null) {
                if (this.getBody() != null) {
                    this.setBody(cryptoManager.decrypt(this.getBody(), this.version));
                    this.decryptAllFromBody(gson);
                }
                if (this.getPrecommitBody() != null) {
                    this.setPrecommitBody(cryptoManager.decrypt(this.getPrecommitBody(), this.version));
                }
            }
        }
        catch (JsonSyntaxException ex) {
            throw new StorageServerException(MSG_ERR_RESPONSE, ex);
        }
        return this.copy();
    }
}

