/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.fields.borders;

import com.itextpdf.forms.fields.borders.AbstractFormBorder;
import com.itextpdf.forms.fields.borders.BeveledBorder;
import com.itextpdf.forms.fields.borders.InsetBorder;
import com.itextpdf.forms.fields.borders.UnderlineBorder;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.borders.FixedDashedBorder;
import com.itextpdf.layout.borders.SolidBorder;

public final class FormBorderFactory {
    private FormBorderFactory() {
        throw new UnsupportedOperationException();
    }

    public static Border getBorder(PdfDictionary borderStyle, float borderWidth, Color borderColor, Color backgroundColor) {
        AbstractFormBorder resultBorder;
        if (borderStyle == null || borderStyle.getAsName(PdfName.S) == null || borderColor == null || borderWidth <= 0.0f) {
            return null;
        }
        PdfName borderType = borderStyle.getAsName(PdfName.S);
        if (PdfName.U.equals((Object)borderType)) {
            resultBorder = new UnderlineBorder(borderColor, borderWidth);
        } else if (PdfName.S.equals((Object)borderType)) {
            resultBorder = new SolidBorder(borderColor, borderWidth);
        } else if (PdfName.D.equals((Object)borderType)) {
            PdfArray dashArray = borderStyle.getAsArray(PdfName.D);
            float unitsOn = 3.0f;
            if (dashArray != null && dashArray.size() > 0 && dashArray.getAsNumber(0) != null) {
                unitsOn = dashArray.getAsNumber(0).intValue();
            }
            float unitsOff = unitsOn;
            if (dashArray != null && dashArray.size() > 1 && dashArray.getAsNumber(1) != null) {
                unitsOff = dashArray.getAsNumber(1).intValue();
            }
            resultBorder = new FixedDashedBorder(borderColor, borderWidth, unitsOn, unitsOff, 0.0f);
        } else {
            resultBorder = PdfName.I.equals((Object)borderType) ? new InsetBorder(borderColor, borderWidth) : (PdfName.B.equals((Object)borderType) ? new BeveledBorder(borderColor, borderWidth, backgroundColor) : null);
        }
        return resultBorder;
    }
}

