/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.fields;

import com.itextpdf.forms.fields.PdfButtonFormField;
import com.itextpdf.forms.fields.PdfFormAnnotation;
import com.itextpdf.forms.fields.PdfFormCreator;
import com.itextpdf.forms.fields.TerminalFormFieldBuilder;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.annot.PdfWidgetAnnotation;

public class RadioFormFieldBuilder
extends TerminalFormFieldBuilder<RadioFormFieldBuilder> {
    public RadioFormFieldBuilder(PdfDocument document, String radioGroupFormFieldName) {
        super(document, radioGroupFormFieldName);
    }

    public PdfButtonFormField createRadioGroup() {
        PdfButtonFormField radioGroup = PdfFormCreator.createButtonFormField(this.getDocument());
        radioGroup.disableFieldRegeneration();
        radioGroup.pdfAConformanceLevel = this.getConformanceLevel();
        radioGroup.setFieldName(this.getFormFieldName());
        radioGroup.setFieldFlags(PdfButtonFormField.FF_RADIO);
        radioGroup.enableFieldRegeneration();
        return radioGroup;
    }

    public PdfFormAnnotation createRadioButton(String appearanceName, Rectangle rectangle) {
        if (appearanceName == null || appearanceName.isEmpty()) {
            throw new PdfException("Appearance name must be provided");
        }
        Rectangle widgetRectangle = this.getWidgetRectangle();
        if (rectangle != null) {
            widgetRectangle = rectangle;
        }
        if (widgetRectangle == null) {
            throw new PdfException("Widget rectangle must be provided");
        }
        PdfName appearancePdfName = new PdfName(appearanceName);
        PdfWidgetAnnotation annotation = new PdfWidgetAnnotation(widgetRectangle);
        annotation.setAppearanceState(appearancePdfName);
        if (this.getConformanceLevel() != null) {
            annotation.setFlag(4);
        }
        PdfFormAnnotation radio = PdfFormCreator.createFormAnnotation(annotation, this.getDocument());
        this.setPageToField(radio);
        radio.pdfAConformanceLevel = this.getConformanceLevel();
        return radio;
    }

    @Override
    protected RadioFormFieldBuilder getThis() {
        return this;
    }
}

