/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl;

import com.itextpdf.commons.datastructures.Tuple2;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfOutline;
import com.itextpdf.kernel.pdf.action.PdfAction;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.styledxmlparser.node.IElementNode;
import com.itextpdf.styledxmlparser.node.impl.jsoup.node.JsoupElementNode;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutlineHandler {
    private static final String DEFAULT_DESTINATION_NAME_PREFIX = "pdfHTML-iText-outline-";
    private Map<String, Integer> destCounter = new HashMap<String, Integer>();
    private PdfOutline currentOutline;
    private Deque<Tuple2<String, PdfDictionary>> destinationsInProcess = new LinkedList<Tuple2<String, PdfDictionary>>();
    private Deque<Integer> levelsInProcess = new LinkedList<Integer>();
    private Map<String, Integer> tagPrioritiesMapping = new HashMap<String, Integer>();
    private String destinationNamePrefix = "pdfHTML-iText-outline-";

    public static OutlineHandler createStandardHandler() {
        OutlineHandler handler = new OutlineHandler();
        handler.putTagPriorityMapping("h1", 1);
        handler.putTagPriorityMapping("h2", 2);
        handler.putTagPriorityMapping("h3", 3);
        handler.putTagPriorityMapping("h4", 4);
        handler.putTagPriorityMapping("h5", 5);
        handler.putTagPriorityMapping("h6", 6);
        return handler;
    }

    public OutlineHandler putTagPriorityMapping(String tagName, Integer priority) {
        this.tagPrioritiesMapping.put(tagName, priority);
        return this;
    }

    public OutlineHandler putAllTagPriorityMappings(Map<String, Integer> mappings) {
        this.tagPrioritiesMapping.putAll(mappings);
        return this;
    }

    public Integer getTagPriorityMapping(String tagName) {
        return this.tagPrioritiesMapping.get(tagName);
    }

    public boolean hasTagPriorityMapping(String tagName) {
        return this.tagPrioritiesMapping.containsKey(tagName);
    }

    public void reset() {
        this.currentOutline = null;
        this.destinationsInProcess.clear();
        this.levelsInProcess.clear();
        this.destCounter.clear();
    }

    public void setDestinationNamePrefix(String destinationNamePrefix) {
        this.destinationNamePrefix = destinationNamePrefix;
    }

    public String getDestinationNamePrefix() {
        return this.destinationNamePrefix;
    }

    protected String generateUniqueDestinationName(IElementNode element) {
        return this.getUniqueID(this.destinationNamePrefix);
    }

    protected String generateOutlineName(IElementNode element) {
        String tagName = element.name();
        String content = ((JsoupElementNode)element).text();
        if (content.isEmpty()) {
            content = this.getUniqueID(tagName);
        }
        return content;
    }

    OutlineHandler addOutlineAndDestToDocument(ITagWorker tagWorker, IElementNode element, ProcessorContext context) {
        String tagName = element.name();
        if (null != tagWorker && this.hasTagPriorityMapping(tagName) && context.getPdfDocument() != null) {
            int level = this.getTagPriorityMapping(tagName);
            if (null == this.currentOutline) {
                this.currentOutline = context.getPdfDocument().getOutlines(false);
            }
            PdfOutline parent = this.currentOutline;
            while (!this.levelsInProcess.isEmpty() && level <= this.levelsInProcess.getFirst()) {
                parent = parent.getParent();
                this.levelsInProcess.pop();
            }
            PdfOutline outline = parent.addOutline(this.generateOutlineName(element));
            String destination = this.generateUniqueDestinationName(element);
            PdfAction action = PdfAction.createGoTo((String)destination);
            outline.addAction(action);
            this.destinationsInProcess.push((Tuple2<String, PdfDictionary>)new Tuple2((Object)destination, (Object)action.getPdfObject()));
            this.levelsInProcess.push(level);
            this.currentOutline = outline;
        }
        return this;
    }

    OutlineHandler setDestinationToElement(ITagWorker tagWorker, IElementNode element) {
        String tagName = element.name();
        if (null != tagWorker && this.hasTagPriorityMapping(tagName) && this.destinationsInProcess.size() > 0) {
            Tuple2<String, PdfDictionary> content = this.destinationsInProcess.pop();
            if (tagWorker.getElementResult() instanceof IElement) {
                tagWorker.getElementResult().setProperty(17, content);
            } else {
                Logger logger = LoggerFactory.getLogger(OutlineHandler.class);
                logger.warn(MessageFormatUtil.format((String)"Tag worker does not produce IPropertyContainer for \"{0}\" tag. An outline for \"{0}\" tag will not be created.", (Object[])new Object[]{tagName}));
            }
        }
        return this;
    }

    private String getUniqueID(String key) {
        if (!this.destCounter.containsKey(key)) {
            this.destCounter.put(key, 1);
        }
        int id = this.destCounter.get(key);
        this.destCounter.put(key, id + 1);
        return key + id;
    }
}

