/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.apply.util;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.properties.BaseDirection;
import com.itextpdf.layout.properties.HorizontalAlignment;
import com.itextpdf.layout.properties.Leading;
import com.itextpdf.layout.properties.LineHeight;
import com.itextpdf.layout.properties.OverflowWrapPropertyValue;
import com.itextpdf.layout.properties.TextAlignment;
import com.itextpdf.layout.properties.TransparentColor;
import com.itextpdf.layout.properties.Underline;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.splitting.BreakAllSplitCharacters;
import com.itextpdf.layout.splitting.DefaultSplitCharacters;
import com.itextpdf.layout.splitting.KeepAllSplitCharacters;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import com.itextpdf.styledxmlparser.node.IElementNode;
import com.itextpdf.styledxmlparser.node.IStylesContainer;
import com.itextpdf.styledxmlparser.util.FontFamilySplitterUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FontStyleApplierUtil {
    private static final Logger logger = LoggerFactory.getLogger(FontStyleApplierUtil.class);
    private static final float DEFAULT_LINE_HEIGHT = 1.2f;
    private static final float TEXT_DECORATION_LINE_DEFAULT_THICKNESS = 0.75f;
    private static final float TEXT_DECORATION_LINE_THROUGH_Y_POS = 0.25f;
    private static final float TEXT_DECORATION_LINE_OVER_Y_POS = 0.9f;
    private static final float TEXT_DECORATION_LIN_UNDER_Y_POS = -0.1f;

    private FontStyleApplierUtil() {
    }

    public static void applyFontStyles(Map<String, String> cssProps, ProcessorContext context, IStylesContainer stylesContainer, IPropertyContainer element) {
        UnitValue wordSpacingValue;
        String wordSpacing;
        UnitValue letterSpacingValue;
        String letterSpacing;
        UnitValue textIndentValue;
        String align;
        String direction;
        String cssColorPropValue;
        float em = CssDimensionParsingUtils.parseAbsoluteLength((String)cssProps.get("font-size"));
        float rem = context.getCssContext().getRootFontSize();
        if (em != 0.0f) {
            element.setProperty(24, (Object)UnitValue.createPointValue((float)em));
        }
        if (cssProps.get("font-family") != null) {
            List fontFamilies = FontFamilySplitterUtil.splitFontFamily((String)cssProps.get("font-family"));
            element.setProperty(20, (Object)fontFamilies.toArray(new String[fontFamilies.size()]));
        }
        if (cssProps.get("font-weight") != null) {
            element.setProperty(95, (Object)cssProps.get("font-weight"));
        }
        if (cssProps.get("font-style") != null) {
            element.setProperty(94, (Object)cssProps.get("font-style"));
        }
        if ((cssColorPropValue = cssProps.get("color")) != null) {
            TransparentColor transparentColor;
            if (!"transparent".equals(cssColorPropValue)) {
                TransparentColor tColor = CssDimensionParsingUtils.parseColor((String)cssColorPropValue);
                Color color = tColor.getColor();
                float opacity = tColor.getOpacity();
                transparentColor = new TransparentColor(color, opacity);
            } else {
                transparentColor = new TransparentColor(ColorConstants.BLACK, 0.0f);
            }
            element.setProperty(21, (Object)transparentColor);
        }
        if ("rtl".equals(direction = cssProps.get("direction"))) {
            element.setProperty(7, (Object)BaseDirection.RIGHT_TO_LEFT);
            if (!"list-item".equals(cssProps.get("display"))) {
                element.setProperty(70, (Object)TextAlignment.RIGHT);
            }
        } else if ("ltr".equals(direction)) {
            element.setProperty(7, (Object)BaseDirection.LEFT_TO_RIGHT);
            if (!"list-item".equals(cssProps.get("display"))) {
                element.setProperty(70, (Object)TextAlignment.LEFT);
            }
        }
        if (stylesContainer instanceof IElementNode && ((IElementNode)stylesContainer).parentNode() instanceof IElementNode && "rtl".equals(((IElementNode)((IElementNode)stylesContainer).parentNode()).getStyles().get("direction")) && !element.hasProperty(28)) {
            element.setProperty(28, (Object)HorizontalAlignment.RIGHT);
        }
        if ("left".equals(align = cssProps.get("text-align"))) {
            element.setProperty(70, (Object)TextAlignment.LEFT);
        } else if ("right".equals(align)) {
            element.setProperty(70, (Object)TextAlignment.RIGHT);
        } else if ("center".equals(align)) {
            element.setProperty(70, (Object)TextAlignment.CENTER);
        } else if ("justify".equals(align)) {
            element.setProperty(70, (Object)TextAlignment.JUSTIFIED);
            element.setProperty(61, (Object)Float.valueOf(1.0f));
        }
        String whiteSpace = cssProps.get("white-space");
        boolean textWrappingDisabled = "nowrap".equals(whiteSpace) || "pre".equals(whiteSpace);
        element.setProperty(118, (Object)textWrappingDisabled);
        if (!textWrappingDisabled) {
            String overflowWrap = cssProps.get("overflow-wrap");
            if ("anywhere".equals(overflowWrap)) {
                element.setProperty(102, (Object)OverflowWrapPropertyValue.ANYWHERE);
            } else if ("break-word".equals(overflowWrap)) {
                element.setProperty(102, (Object)OverflowWrapPropertyValue.BREAK_WORD);
            } else {
                element.setProperty(102, (Object)OverflowWrapPropertyValue.NORMAL);
            }
            String wordBreak = cssProps.get("word-break");
            if ("break-all".equals(wordBreak)) {
                element.setProperty(62, (Object)new BreakAllSplitCharacters());
            } else if ("keep-all".equals(wordBreak)) {
                element.setProperty(62, (Object)new KeepAllSplitCharacters());
            } else if ("break-word".equals(wordBreak)) {
                element.setProperty(102, (Object)OverflowWrapPropertyValue.ANYWHERE);
                element.setProperty(62, (Object)new DefaultSplitCharacters());
            } else {
                element.setProperty(62, (Object)new DefaultSplitCharacters());
            }
        }
        FontStyleApplierUtil.setTextDecoration(element, cssProps);
        String textIndent = cssProps.get("text-indent");
        if (textIndent != null && (textIndentValue = CssDimensionParsingUtils.parseLengthValueToPt((String)textIndent, (float)em, (float)rem)) != null) {
            if (textIndentValue.isPointValue()) {
                element.setProperty(18, (Object)Float.valueOf(textIndentValue.getValue()));
            } else {
                logger.error(MessageFormatUtil.format((String)"Css property {0} in percents is not supported", (Object[])new Object[]{"text-indent"}));
            }
        }
        if ((letterSpacing = cssProps.get("letter-spacing")) != null && !"normal".equals(letterSpacing) && (letterSpacingValue = CssDimensionParsingUtils.parseLengthValueToPt((String)letterSpacing, (float)em, (float)rem)).isPointValue()) {
            element.setProperty(15, (Object)Float.valueOf(letterSpacingValue.getValue()));
        }
        if ((wordSpacing = cssProps.get("word-spacing")) != null && (wordSpacingValue = CssDimensionParsingUtils.parseLengthValueToPt((String)wordSpacing, (float)em, (float)rem)) != null && wordSpacingValue.isPointValue()) {
            element.setProperty(78, (Object)Float.valueOf(wordSpacingValue.getValue()));
        }
        String lineHeight = cssProps.get("line-height");
        FontStyleApplierUtil.setLineHeight(element, lineHeight, em, rem);
        FontStyleApplierUtil.setLineHeightByLeading(element, lineHeight, em, rem);
    }

    private static void setTextDecoration(IPropertyContainer element, Map<String, String> cssProps) {
        String[] props = new String[]{null};
        String unparsedProps = cssProps.get("text-decoration-color");
        if (unparsedProps != null && !unparsedProps.trim().isEmpty()) {
            props = cssProps.get("text-decoration-color").split("\\s+");
        }
        ArrayList<Float> opacityList = new ArrayList<Float>(props.length);
        ArrayList<Color> colorList = new ArrayList<Color>(props.length);
        for (String textDecorationColorProp : props) {
            Color textDecorationColor;
            float opacity = 1.0f;
            if (textDecorationColorProp == null || "currentcolor".equals(textDecorationColorProp)) {
                if (element.getProperty(21) != null) {
                    TransparentColor transparentColor = (TransparentColor)element.getProperty(21);
                    textDecorationColor = transparentColor.getColor();
                    opacity = transparentColor.getOpacity();
                } else {
                    textDecorationColor = ColorConstants.BLACK;
                }
            } else if (textDecorationColorProp.startsWith("hsl")) {
                logger.error("Hsl colors are not supported");
                textDecorationColor = ColorConstants.BLACK;
            } else {
                TransparentColor tColor = CssDimensionParsingUtils.parseColor((String)textDecorationColorProp);
                textDecorationColor = tColor.getColor();
                opacity = tColor.getOpacity();
            }
            opacityList.add(Float.valueOf(opacity));
            colorList.add(textDecorationColor);
        }
        String textDecorationLineProp = cssProps.get("text-decoration-line");
        if (textDecorationLineProp == null) {
            return;
        }
        String[] textDecorationArray = textDecorationLineProp.split("\\s+");
        ArrayList<Underline> underlineList = new ArrayList<Underline>();
        for (int currentIndex = 0; currentIndex < textDecorationArray.length; ++currentIndex) {
            float opacity = opacityList.size() - 1 > currentIndex ? ((Float)opacityList.get(currentIndex)).floatValue() : ((Float)opacityList.get(opacityList.size() - 1)).floatValue();
            Color color = colorList.size() - 1 > currentIndex ? (Color)colorList.get(currentIndex) : (Color)colorList.get(colorList.size() - 1);
            String line = textDecorationArray[currentIndex];
            if ("blink".equals(line)) {
                logger.error("text-decoration: blink not supported");
                continue;
            }
            if ("line-through".equals(line)) {
                underlineList.add(new Underline(color, opacity, 0.75f, 0.0f, 0.0f, 0.25f, 0));
                continue;
            }
            if ("overline".equals(line)) {
                underlineList.add(new Underline(color, opacity, 0.75f, 0.0f, 0.0f, 0.9f, 0));
                continue;
            }
            if ("underline".equals(line)) {
                underlineList.add(new Underline(color, opacity, 0.75f, 0.0f, 0.0f, -0.1f, 0));
                continue;
            }
            if (!"none".equals(line)) continue;
            underlineList = null;
            break;
        }
        element.setProperty(74, underlineList);
    }

    private static void setLineHeight(IPropertyContainer elementToSet, String lineHeight, float em, float rem) {
        if (lineHeight != null && !"normal".equals(lineHeight) && !"auto".equals(lineHeight)) {
            if (CssTypesValidationUtils.isNumber((String)lineHeight)) {
                Float number = CssDimensionParsingUtils.parseFloat((String)lineHeight);
                if (number != null) {
                    elementToSet.setProperty(124, (Object)LineHeight.createMultipliedValue((float)number.floatValue()));
                } else {
                    elementToSet.setProperty(124, (Object)LineHeight.createNormalValue());
                }
            } else {
                UnitValue lineHeightValue = CssDimensionParsingUtils.parseLengthValueToPt((String)lineHeight, (float)em, (float)rem);
                if (lineHeightValue != null && lineHeightValue.isPointValue()) {
                    elementToSet.setProperty(124, (Object)LineHeight.createFixedValue((float)lineHeightValue.getValue()));
                } else if (lineHeightValue != null) {
                    elementToSet.setProperty(124, (Object)LineHeight.createMultipliedValue((float)(lineHeightValue.getValue() / 100.0f)));
                } else {
                    elementToSet.setProperty(124, (Object)LineHeight.createNormalValue());
                }
            }
        } else {
            elementToSet.setProperty(124, (Object)LineHeight.createNormalValue());
        }
    }

    private static void setLineHeightByLeading(IPropertyContainer element, String lineHeight, float em, float rem) {
        if (lineHeight != null && !"normal".equals(lineHeight) && !"auto".equals(lineHeight)) {
            if (CssTypesValidationUtils.isNumber((String)lineHeight)) {
                Float mult = CssDimensionParsingUtils.parseFloat((String)lineHeight);
                if (mult != null) {
                    element.setProperty(33, (Object)new Leading(2, mult.floatValue()));
                }
            } else {
                UnitValue lineHeightValue = CssDimensionParsingUtils.parseLengthValueToPt((String)lineHeight, (float)em, (float)rem);
                if (lineHeightValue != null && lineHeightValue.isPointValue()) {
                    element.setProperty(33, (Object)new Leading(1, lineHeightValue.getValue()));
                } else if (lineHeightValue != null) {
                    element.setProperty(33, (Object)new Leading(2, lineHeightValue.getValue() / 100.0f));
                }
            }
        } else {
            element.setProperty(33, (Object)new Leading(2, 1.2f));
        }
    }
}

