/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.resolver.font;

import com.itextpdf.io.util.ResourceUtil;
import com.itextpdf.io.util.StreamUtil;
import com.itextpdf.layout.font.Range;
import com.itextpdf.layout.font.RangeBuilder;
import com.itextpdf.layout.renderer.TypographyUtils;
import com.itextpdf.styledxmlparser.resolver.font.BasicFontProvider;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFontProvider
extends BasicFontProvider {
    static final String SHIPPED_FONT_RESOURCE_PATH = "com/itextpdf/html2pdf/font/";
    static final String[] SHIPPED_FONT_NAMES = new String[]{"NotoSansMono-Regular.ttf", "NotoSansMono-Bold.ttf", "NotoSans-Regular.ttf", "NotoSans-Bold.ttf", "NotoSans-BoldItalic.ttf", "NotoSans-Italic.ttf", "NotoSerif-Regular.ttf", "NotoSerif-Bold.ttf", "NotoSerif-BoldItalic.ttf", "NotoSerif-Italic.ttf"};
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFontProvider.class);
    private static final String DEFAULT_FONT_FAMILY = "Times";
    private static final Range FREE_FONT_RANGE = new RangeBuilder().addRange(0, 1423).addRange(3712, Integer.MAX_VALUE).create();
    private List<byte[]> calligraphyFontsTempList = new ArrayList<byte[]>();

    public DefaultFontProvider() {
        this(true, true, false);
    }

    public DefaultFontProvider(boolean registerStandardPdfFonts, boolean registerShippedFonts, boolean registerSystemFonts) {
        this(registerStandardPdfFonts, registerShippedFonts, registerSystemFonts, DEFAULT_FONT_FAMILY);
    }

    public DefaultFontProvider(boolean registerStandardPdfFonts, boolean registerShippedFonts, boolean registerSystemFonts, String defaultFontFamily) {
        super(registerStandardPdfFonts, registerSystemFonts, defaultFontFamily);
        if (registerShippedFonts) {
            this.addAllAvailableFonts(this.addCalligraphFonts());
        }
    }

    private void addAllAvailableFonts(Range rangeToLoad) {
        this.addShippedFonts(rangeToLoad);
        for (byte[] fontData : this.calligraphyFontsTempList) {
            this.addFont(fontData, null);
        }
        this.calligraphyFontsTempList = null;
    }

    private void addShippedFonts(Range rangeToLoad) {
        for (String fontName : SHIPPED_FONT_NAMES) {
            try (InputStream stream = ResourceUtil.getResourceStream((String)(SHIPPED_FONT_RESOURCE_PATH + fontName));){
                byte[] fontProgramBytes = StreamUtil.inputStreamToArray((InputStream)stream);
                this.addFont(fontProgramBytes, null, rangeToLoad);
            }
            catch (Exception e) {
                LOGGER.error("Error while loading font");
            }
        }
    }

    protected Range addCalligraphFonts() {
        if (TypographyUtils.isPdfCalligraphAvailable()) {
            try {
                Map fontStreams = TypographyUtils.loadShippedFonts();
                this.calligraphyFontsTempList.addAll(fontStreams.values());
                return FREE_FONT_RANGE;
            }
            catch (Exception e) {
                LOGGER.error("Error while loading font");
            }
        }
        return null;
    }
}

