/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.resolver.resource;

import com.itextpdf.commons.utils.Base64;
import com.itextpdf.commons.utils.FileUtil;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.util.ContextMappingHelper;
import com.itextpdf.html2pdf.util.SvgProcessingUtil;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.styledxmlparser.resolver.resource.IResourceRetriever;
import com.itextpdf.styledxmlparser.resolver.resource.ResourceResolver;
import com.itextpdf.svg.converter.SvgConverter;
import com.itextpdf.svg.processors.ISvgConverterProperties;
import com.itextpdf.svg.processors.ISvgProcessorResult;
import com.itextpdf.svg.processors.impl.SvgConverterProperties;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;

public class HtmlResourceResolver
extends ResourceResolver {
    private static final String SVG_PREFIX = "data:image/svg+xml";
    private static final Pattern SVG_IDENTIFIER_PATTERN = Pattern.compile(",[\\s]*(<svg )");
    private final ProcessorContext context;

    public HtmlResourceResolver(String baseUri, ProcessorContext context) {
        this(baseUri, context, null);
    }

    public HtmlResourceResolver(String baseUri, ProcessorContext context, IResourceRetriever retriever) {
        super(baseUri, retriever);
        this.context = context;
    }

    public PdfXObject retrieveImage(String src) {
        PdfXObject imageXObject;
        if (src != null && src.trim().startsWith(SVG_PREFIX) && SVG_IDENTIFIER_PATTERN.matcher(src).find() && (imageXObject = this.tryResolveSvgImageSource(src)) != null) {
            return imageXObject;
        }
        return super.retrieveImage(src);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PdfXObject tryResolveBase64ImageSource(String src) {
        String fixedSrc = src.replaceAll("\\s", "");
        if (!fixedSrc.startsWith(SVG_PREFIX)) return super.tryResolveBase64ImageSource(src);
        fixedSrc = fixedSrc.substring(fixedSrc.indexOf("base64") + "base64".length() + 1);
        try (ByteArrayInputStream stream = new ByteArrayInputStream(Base64.decode((String)fixedSrc));){
            PdfFormXObject xObject = HtmlResourceResolver.processAsSvg(stream, this.context, null);
            if (xObject == null) return super.tryResolveBase64ImageSource(src);
            PdfFormXObject pdfFormXObject = xObject;
            return pdfFormXObject;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.tryResolveBase64ImageSource(src);
    }

    protected PdfXObject createImageByUrl(URL url) throws Exception {
        try {
            return super.createImageByUrl(url);
        }
        catch (Exception ignored) {
            try (InputStream is = this.getRetriever().getInputStreamByUrl(url);){
                PdfFormXObject pdfFormXObject = is == null ? null : HtmlResourceResolver.processAsSvg(is, this.context, FileUtil.parentDirectory((URL)url));
                return pdfFormXObject;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PdfXObject tryResolveSvgImageSource(String src) {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(src.getBytes(StandardCharsets.UTF_8));){
            PdfFormXObject xObject = HtmlResourceResolver.processAsSvg(stream, this.context, null);
            if (xObject == null) return null;
            PdfFormXObject pdfFormXObject = xObject;
            return pdfFormXObject;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static PdfFormXObject processAsSvg(InputStream stream, ProcessorContext context, String parentDir) {
        SvgConverterProperties svgConverterProperties = ContextMappingHelper.mapToSvgConverterProperties(context);
        if (parentDir != null) {
            svgConverterProperties.setBaseUri(parentDir);
        }
        ISvgProcessorResult res = SvgConverter.parseAndProcess((InputStream)stream, (ISvgConverterProperties)svgConverterProperties);
        SvgProcessingUtil processingUtil = new SvgProcessingUtil(context.getResourceResolver());
        return processingUtil.createXObjectFromProcessingResult(res, context.getPdfDocument());
    }
}

