/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.crypto;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.kernel.exceptions.PdfException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESCipher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AESCipher.class);
    private static final String CIPHER_WITH_PKCS5_PADDING = "AES/CBC/PKCS5Padding";
    private static final IBouncyCastleFactory BOUNCY_CASTLE_FACTORY = BouncyCastleFactoryCreator.getFactory();
    private static Cipher cipher;

    public AESCipher(boolean forEncryption, byte[] key, byte[] iv) {
        try {
            cipher.init(forEncryption ? 1 : 2, (Key)new SecretKeySpec(key, "AES"), new IvParameterSpec(iv));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw new PdfException("Exception initializing AES cipher.", e);
        }
    }

    public byte[] update(byte[] inp, int inpOff, int inpLen) {
        return cipher.update(inp, inpOff, inpLen);
    }

    public byte[] doFinal() {
        try {
            return cipher.doFinal();
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            LOGGER.info("Exception finalizing AES cipher.", (Throwable)e);
            return null;
        }
    }

    static {
        try {
            cipher = "BC".equals(BOUNCY_CASTLE_FACTORY.getProviderName()) ? Cipher.getInstance(CIPHER_WITH_PKCS5_PADDING) : Cipher.getInstance(CIPHER_WITH_PKCS5_PADDING, BOUNCY_CASTLE_FACTORY.getProvider());
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new PdfException("Exception initializing AES cipher.", e);
        }
    }
}

