/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css;

import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.CssStatement;
import com.itextpdf.styledxmlparser.css.media.MediaDeviceDescription;
import com.itextpdf.styledxmlparser.css.selector.ICssSelector;
import com.itextpdf.styledxmlparser.node.INode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class CssRuleSet
extends CssStatement {
    private static final Pattern IMPORTANT_MATCHER = Pattern.compile(".*!\\s*important$");
    private ICssSelector selector;
    private List<CssDeclaration> normalDeclarations;
    private List<CssDeclaration> importantDeclarations;

    public CssRuleSet(ICssSelector selector, List<CssDeclaration> declarations) {
        this.selector = selector;
        this.normalDeclarations = new ArrayList<CssDeclaration>();
        this.importantDeclarations = new ArrayList<CssDeclaration>();
        CssRuleSet.splitDeclarationsIntoNormalAndImportant(declarations, this.normalDeclarations, this.importantDeclarations);
    }

    public CssRuleSet(ICssSelector selector, List<CssDeclaration> normalDeclarations, List<CssDeclaration> importantDeclarations) {
        this.selector = selector;
        this.normalDeclarations = normalDeclarations;
        this.importantDeclarations = importantDeclarations;
    }

    @Override
    public List<CssRuleSet> getCssRuleSets(INode element, MediaDeviceDescription deviceDescription) {
        if (this.selector.matches(element)) {
            return Collections.singletonList(this);
        }
        return super.getCssRuleSets(element, deviceDescription);
    }

    public String toString() {
        CssDeclaration declaration;
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(this.selector.toString());
        sb.append(" {\n");
        for (i = 0; i < this.normalDeclarations.size(); ++i) {
            if (i > 0) {
                sb.append(";").append("\n");
            }
            declaration = this.normalDeclarations.get(i);
            sb.append("    ").append(declaration.toString());
        }
        for (i = 0; i < this.importantDeclarations.size(); ++i) {
            if (i > 0 || this.normalDeclarations.size() > 0) {
                sb.append(";").append("\n");
            }
            declaration = this.importantDeclarations.get(i);
            sb.append("    ").append(declaration.toString()).append(" !important");
        }
        sb.append("\n}");
        return sb.toString();
    }

    public ICssSelector getSelector() {
        return this.selector;
    }

    public List<CssDeclaration> getNormalDeclarations() {
        return this.normalDeclarations;
    }

    public List<CssDeclaration> getImportantDeclarations() {
        return this.importantDeclarations;
    }

    private static void splitDeclarationsIntoNormalAndImportant(List<CssDeclaration> declarations, List<CssDeclaration> normalDeclarations, List<CssDeclaration> importantDeclarations) {
        for (CssDeclaration declaration : declarations) {
            int exclIndex = declaration.getExpression().indexOf(33);
            if (exclIndex > 0 && IMPORTANT_MATCHER.matcher(declaration.getExpression()).matches()) {
                importantDeclarations.add(new CssDeclaration(declaration.getProperty(), declaration.getExpression().substring(0, exclIndex).trim()));
                continue;
            }
            normalDeclarations.add(declaration);
        }
    }
}

