/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.selector.item;

import com.itextpdf.styledxmlparser.css.selector.item.CssPseudoClassChildSelectorItem;
import com.itextpdf.styledxmlparser.node.ICustomElementNode;
import com.itextpdf.styledxmlparser.node.IDocumentNode;
import com.itextpdf.styledxmlparser.node.IElementNode;
import com.itextpdf.styledxmlparser.node.INode;
import java.util.List;

class CssPseudoClassNthSelectorItem
extends CssPseudoClassChildSelectorItem {
    private int nthA;
    private int nthB;

    CssPseudoClassNthSelectorItem(String pseudoClass, String arguments) {
        super(pseudoClass, arguments);
        this.getNthArguments();
    }

    @Override
    public boolean matches(INode node) {
        if (!(node instanceof IElementNode) || node instanceof ICustomElementNode || node instanceof IDocumentNode) {
            return false;
        }
        List<INode> children = this.getAllSiblings(node);
        return !children.isEmpty() && this.resolveNth(node, children);
    }

    protected void getNthArguments() {
        if (this.arguments.matches("((-|\\+)?[0-9]*n(\\s*(-|\\+)\\s*[0-9]+)?|(-|\\+)?[0-9]+|odd|even)")) {
            if (this.arguments.equals("odd")) {
                this.nthA = 2;
                this.nthB = 1;
            } else if (this.arguments.equals("even")) {
                this.nthA = 2;
                this.nthB = 0;
            } else {
                int indexOfN = this.arguments.indexOf(110);
                if (indexOfN == -1) {
                    this.nthA = 0;
                    this.nthB = Integer.parseInt(this.arguments);
                } else {
                    String aParticle = this.arguments.substring(0, indexOfN).trim();
                    this.nthA = aParticle.isEmpty() ? 0 : (aParticle.length() == 1 && !Character.isDigit(aParticle.charAt(0)) ? (aParticle.equals("+") ? 1 : -1) : Integer.parseInt(aParticle));
                    String bParticle = this.arguments.substring(indexOfN + 1).trim();
                    this.nthB = !bParticle.isEmpty() ? Integer.parseInt(bParticle.charAt(0) + bParticle.substring(1).trim()) : 0;
                }
            }
        } else {
            this.nthA = 0;
            this.nthB = 0;
        }
    }

    protected boolean resolveNth(INode node, List<INode> children) {
        if (!children.contains(node)) {
            return false;
        }
        if (this.nthA > 0) {
            int temp = children.indexOf(node) + 1 - this.nthB;
            return temp >= 0 && temp % this.nthA == 0;
        }
        if (this.nthA < 0) {
            int temp = children.indexOf(node) + 1 - this.nthB;
            return temp <= 0 && temp % this.nthA == 0;
        }
        return children.indexOf(node) + 1 - this.nthB == 0;
    }
}

