/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.html.pdfelement;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.List;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.api.Indentable;

public class NoNewLineParagraph
extends Phrase
implements Indentable {
    private static final long serialVersionUID = -8392940968188620772L;
    protected int alignment = -1;
    protected float indentationLeft;
    protected float indentationRight;
    private float firstLineIndent = 0.0f;
    protected float spacingBefore;
    protected float spacingAfter;
    private float extraParagraphSpace = 0.0f;
    protected boolean keeptogether = false;

    public NoNewLineParagraph() {
    }

    public NoNewLineParagraph(float leading) {
        super(leading);
    }

    public NoNewLineParagraph(Chunk chunk) {
        super(chunk);
    }

    public NoNewLineParagraph(float leading, Chunk chunk) {
        super(leading, chunk);
    }

    public NoNewLineParagraph(String string) {
        super(string);
    }

    public NoNewLineParagraph(String string, Font font) {
        super(string, font);
    }

    public NoNewLineParagraph(float leading, String string) {
        super(leading, string);
    }

    public NoNewLineParagraph(float leading, String string, Font font) {
        super(leading, string, font);
    }

    public NoNewLineParagraph(Phrase phrase) {
        super(phrase);
        NoNewLineParagraph p;
        if (phrase instanceof NoNewLineParagraph) {
            p = (NoNewLineParagraph)phrase;
            this.alignment = p.getAlignment();
            this.indentationLeft = p.getIndentationLeft();
            this.indentationRight = p.getIndentationRight();
            this.firstLineIndent = p.getFirstLineIndent();
            this.spacingAfter = p.getSpacingAfter();
            this.spacingBefore = p.getSpacingBefore();
            this.extraParagraphSpace = p.getExtraParagraphSpace();
        }
        if (phrase instanceof Paragraph) {
            p = (Paragraph)phrase;
            this.setAlignment(p.getAlignment());
            this.setIndentationLeft(p.getIndentationLeft());
            this.setIndentationRight(p.getIndentationRight());
            this.setFirstLineIndent(p.getFirstLineIndent());
            this.setSpacingAfter(p.getSpacingAfter());
            this.setSpacingBefore(p.getSpacingBefore());
            this.setExtraParagraphSpace(p.getExtraParagraphSpace());
        }
    }

    public boolean add(Element o) {
        if (o instanceof List) {
            List list = (List)o;
            list.setIndentationLeft(list.getIndentationLeft() + this.indentationLeft);
            list.setIndentationRight(this.indentationRight);
            return super.add((Element)list);
        }
        if (o instanceof Image) {
            super.addSpecial(o);
            return true;
        }
        return super.add(o);
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public void setIndentationLeft(float indentation) {
        this.indentationLeft = indentation;
    }

    public void setIndentationRight(float indentation) {
        this.indentationRight = indentation;
    }

    public void setFirstLineIndent(float firstLineIndent) {
        this.firstLineIndent = firstLineIndent;
    }

    public void setSpacingBefore(float spacing) {
        this.spacingBefore = spacing;
    }

    public void setSpacingAfter(float spacing) {
        this.spacingAfter = spacing;
    }

    public void setKeepTogether(boolean keeptogether) {
        this.keeptogether = keeptogether;
    }

    public boolean getKeepTogether() {
        return this.keeptogether;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public float getIndentationLeft() {
        return this.indentationLeft;
    }

    public float getIndentationRight() {
        return this.indentationRight;
    }

    public float getFirstLineIndent() {
        return this.firstLineIndent;
    }

    public float getSpacingBefore() {
        return this.spacingBefore;
    }

    public float getSpacingAfter() {
        return this.spacingAfter;
    }

    public float getExtraParagraphSpace() {
        return this.extraParagraphSpace;
    }

    public void setExtraParagraphSpace(float extraParagraphSpace) {
        this.extraParagraphSpace = extraParagraphSpace;
    }

    @Deprecated
    public float spacingBefore() {
        return this.getSpacingBefore();
    }

    @Deprecated
    public float spacingAfter() {
        return this.spacingAfter;
    }
}

