/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxrelay2;

import com.jakewharton.rxrelay2.AppendOnlyLinkedArrayList;
import com.jakewharton.rxrelay2.Relay;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import java.lang.reflect.Array;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class BehaviorRelay<T>
extends Relay<T> {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    final AtomicReference<T> value;
    private final AtomicReference<BehaviorDisposable<T>[]> subscribers;
    private static final BehaviorDisposable[] EMPTY = new BehaviorDisposable[0];
    final Lock readLock;
    private final Lock writeLock;
    long index;

    public static <T> BehaviorRelay<T> create() {
        return new BehaviorRelay<T>();
    }

    public static <T> BehaviorRelay<T> createDefault(T defaultValue) {
        return new BehaviorRelay<T>(defaultValue);
    }

    private BehaviorRelay() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.subscribers = new AtomicReference<BehaviorDisposable[]>(EMPTY);
        this.value = new AtomicReference();
    }

    private BehaviorRelay(T defaultValue) {
        this();
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue == null");
        }
        this.value.lazySet(defaultValue);
    }

    protected void subscribeActual(Observer<? super T> observer) {
        BehaviorDisposable<T> bs = new BehaviorDisposable<T>(observer, this);
        observer.onSubscribe(bs);
        this.add(bs);
        if (bs.cancelled) {
            this.remove(bs);
        } else {
            bs.emitFirst();
        }
    }

    @Override
    public void accept(T value) {
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        this.setCurrent(value);
        for (BehaviorDisposable<T> bs : this.subscribers.get()) {
            bs.emitNext(value, this.index);
        }
    }

    @Override
    public boolean hasObservers() {
        return this.subscribers.get().length != 0;
    }

    int subscriberCount() {
        return this.subscribers.get().length;
    }

    public T getValue() {
        return this.value.get();
    }

    public Object[] getValues() {
        Object[] a = EMPTY_ARRAY;
        Object[] b = this.getValues(a);
        if (b == EMPTY_ARRAY) {
            return new Object[0];
        }
        return b;
    }

    public T[] getValues(T[] array) {
        T o = this.value.get();
        if (o == null) {
            if (array.length != 0) {
                array[0] = null;
            }
            return array;
        }
        if (array.length != 0) {
            array[0] = o;
            if (array.length != 1) {
                array[1] = null;
            }
        } else {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), 1);
            array[0] = o;
        }
        return array;
    }

    public boolean hasValue() {
        return this.value.get() != null;
    }

    private void add(BehaviorDisposable<T> rs) {
        BehaviorDisposable[] b;
        BehaviorDisposable<T>[] a;
        do {
            a = this.subscribers.get();
            int len = a.length;
            b = new BehaviorDisposable[len + 1];
            System.arraycopy(a, 0, b, 0, len);
            b[len] = rs;
        } while (!this.subscribers.compareAndSet(a, b));
    }

    void remove(BehaviorDisposable<T> rs) {
        BehaviorDisposable[] b;
        BehaviorDisposable<T>[] a;
        do {
            if ((a = this.subscribers.get()) == EMPTY) {
                return;
            }
            int len = a.length;
            int j = -1;
            for (int i = 0; i < len; ++i) {
                if (a[i] != rs) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (len == 1) {
                b = EMPTY;
                continue;
            }
            b = new BehaviorDisposable[len - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, len - j - 1);
        } while (!this.subscribers.compareAndSet(a, b));
    }

    private void setCurrent(T current) {
        this.writeLock.lock();
        try {
            ++this.index;
            this.value.lazySet(current);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    static final class BehaviorDisposable<T>
    implements Disposable,
    AppendOnlyLinkedArrayList.NonThrowingPredicate<T> {
        final Observer<? super T> actual;
        final BehaviorRelay<T> state;
        boolean next;
        boolean emitting;
        AppendOnlyLinkedArrayList<T> queue;
        boolean fastPath;
        volatile boolean cancelled;
        long index;

        BehaviorDisposable(Observer<? super T> actual, BehaviorRelay<T> state) {
            this.actual = actual;
            this.state = state;
        }

        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.state.remove(this);
            }
        }

        public boolean isDisposed() {
            return this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitFirst() {
            Object o;
            if (this.cancelled) {
                return;
            }
            BehaviorDisposable behaviorDisposable = this;
            synchronized (behaviorDisposable) {
                if (this.cancelled) {
                    return;
                }
                if (this.next) {
                    return;
                }
                BehaviorRelay<T> s = this.state;
                Lock lock = s.readLock;
                lock.lock();
                this.index = s.index;
                o = s.value.get();
                lock.unlock();
                this.emitting = o != null;
                this.next = true;
            }
            if (o != null) {
                this.test(o);
                this.emitLoop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitNext(T value, long stateIndex) {
            if (this.cancelled) {
                return;
            }
            if (!this.fastPath) {
                BehaviorDisposable behaviorDisposable = this;
                synchronized (behaviorDisposable) {
                    if (this.cancelled) {
                        return;
                    }
                    if (this.index == stateIndex) {
                        return;
                    }
                    if (this.emitting) {
                        AppendOnlyLinkedArrayList<T> q = this.queue;
                        if (q == null) {
                            q = new AppendOnlyLinkedArrayList(4);
                            this.queue = q;
                        }
                        q.add(value);
                        return;
                    }
                    this.next = true;
                }
                this.fastPath = true;
            }
            this.test(value);
        }

        @Override
        public boolean test(T o) {
            if (!this.cancelled) {
                this.actual.onNext(o);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitLoop() {
            while (!this.cancelled) {
                AppendOnlyLinkedArrayList<T> q;
                BehaviorDisposable behaviorDisposable = this;
                synchronized (behaviorDisposable) {
                    q = this.queue;
                    if (q == null) {
                        this.emitting = false;
                        return;
                    }
                    this.queue = null;
                }
                q.forEachWhile(this);
            }
            return;
        }
    }
}

