/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.config;

import com.jayway.restassured.config.Config;
import com.jayway.restassured.internal.assertion.AssertParameter;

public class ParamConfig
implements Config {
    private final boolean userConfigured;
    private final UpdateStrategy queryParamsUpdateStrategy;
    private final UpdateStrategy formParamsUpdateStrategy;
    private final UpdateStrategy requestParameterUpdateStrategy;

    public ParamConfig() {
        this(UpdateStrategy.MERGE, UpdateStrategy.MERGE, UpdateStrategy.MERGE, false);
    }

    public ParamConfig(UpdateStrategy queryParamsUpdateStrategy, UpdateStrategy formParamsUpdateStrategy, UpdateStrategy requestParameterUpdateStrategy) {
        this(queryParamsUpdateStrategy, formParamsUpdateStrategy, requestParameterUpdateStrategy, true);
    }

    private ParamConfig(UpdateStrategy queryParamsUpdateStrategy, UpdateStrategy formParamsUpdateStrategy, UpdateStrategy requestParameterUpdateStrategy, boolean userConfigured) {
        AssertParameter.notNull((Object)((Object)queryParamsUpdateStrategy), (String)"Query param update strategy");
        AssertParameter.notNull((Object)((Object)requestParameterUpdateStrategy), (String)"Request param update strategy");
        AssertParameter.notNull((Object)((Object)formParamsUpdateStrategy), (String)"Form param update strategy");
        this.queryParamsUpdateStrategy = queryParamsUpdateStrategy;
        this.formParamsUpdateStrategy = formParamsUpdateStrategy;
        this.requestParameterUpdateStrategy = requestParameterUpdateStrategy;
        this.userConfigured = userConfigured;
    }

    public ParamConfig mergeAllParameters() {
        return new ParamConfig(UpdateStrategy.MERGE, UpdateStrategy.MERGE, UpdateStrategy.MERGE, true);
    }

    public ParamConfig replaceAllParameters() {
        return new ParamConfig(UpdateStrategy.REPLACE, UpdateStrategy.REPLACE, UpdateStrategy.REPLACE, true);
    }

    public ParamConfig formParamsUpdateStrategy(UpdateStrategy updateStrategy) {
        return new ParamConfig(this.queryParamsUpdateStrategy, updateStrategy, this.requestParameterUpdateStrategy, true);
    }

    public ParamConfig requestParamsUpdateStrategy(UpdateStrategy updateStrategy) {
        return new ParamConfig(this.queryParamsUpdateStrategy, this.formParamsUpdateStrategy, updateStrategy, true);
    }

    public ParamConfig queryParamsUpdateStrategy(UpdateStrategy updateStrategy) {
        return new ParamConfig(updateStrategy, this.formParamsUpdateStrategy, this.requestParameterUpdateStrategy, true);
    }

    public UpdateStrategy formParamsUpdateStrategy() {
        return this.formParamsUpdateStrategy;
    }

    public UpdateStrategy requestParamsUpdateStrategy() {
        return this.requestParameterUpdateStrategy;
    }

    public UpdateStrategy queryParamsUpdateStrategy() {
        return this.queryParamsUpdateStrategy;
    }

    public boolean isUserConfigured() {
        return this.userConfigured;
    }

    public static ParamConfig paramConfig() {
        return new ParamConfig();
    }

    public ParamConfig and() {
        return this;
    }

    public ParamConfig with() {
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UpdateStrategy {
        MERGE,
        REPLACE;

    }
}

