/*
 * Decompiled with CFR 0.152.
 */
package org.xembly;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;

public interface Transformers {
    public Transformer create();

    public static final class Formatted
    implements Transformers {
        private final Transformers original;
        private final Map<String, String> properties;

        Formatted(Transformers original, Map<String, String> properties) {
            this.original = original;
            this.properties = properties;
        }

        @Override
        public Transformer create() {
            Transformer transformer = this.original.create();
            this.properties.forEach(transformer::setOutputProperty);
            return transformer;
        }
    }

    public static final class Default
    implements Transformers {
        private static TransformerFactory tfactory = TransformerFactory.newInstance();
        private final TransformerFactory factory;

        Default() {
            this(tfactory);
        }

        private Default(TransformerFactory factory) {
            this.factory = factory;
        }

        @Override
        public Transformer create() {
            try {
                return this.factory.newTransformer();
            }
            catch (TransformerConfigurationException ex) {
                throw new IllegalStateException(String.format("Failed to create new Transformer at %s", this.factory.getClass().getCanonicalName()), ex);
            }
        }
    }

    public static final class Document
    implements Transformers {
        private final Transformers original = new Formatted(new Default(), Document.defaultProperties());

        @Override
        public Transformer create() {
            return this.original.create();
        }

        private static Map<String, String> defaultProperties() {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("indent", "yes");
            res.put("encoding", "UTF-8");
            return res;
        }
    }

    public static final class Node
    implements Transformers {
        private final Transformers original = new Formatted(new Default(), Collections.singletonMap("omit-xml-declaration", "yes"));

        @Override
        public Transformer create() {
            return this.original.create();
        }
    }
}

