/*
 * Decompiled with CFR 0.152.
 */
package org.xembly;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.xembly.Arg;
import org.xembly.Directive;
import org.xembly.ImpossibleModificationException;
import org.xembly.XmlContentException;

final class XsetDirective
implements Directive {
    private static final XPathFactory FACTORY = XPathFactory.newInstance();
    private final Arg expr;

    XsetDirective(String val) throws XmlContentException {
        this.expr = new Arg(val);
    }

    public String toString() {
        return String.format("XSET %s", this.expr);
    }

    @Override
    public Directive.Cursor exec(Node dom, Directive.Cursor cursor, Directive.Stack stack) throws ImpossibleModificationException {
        ConcurrentHashMap<Node, String> values = new ConcurrentHashMap<Node, String>(0);
        XPath xpath = FACTORY.newXPath();
        for (Node node : cursor) {
            try {
                values.put(node, xpath.evaluate(this.expr.raw(), node, XPathConstants.STRING).toString());
            }
            catch (XPathExpressionException ex) {
                throw new ImpossibleModificationException(String.format("Invalid XPath expression '%s'", this.expr), ex);
            }
        }
        for (Map.Entry entry : values.entrySet()) {
            ((Node)entry.getKey()).setTextContent((String)entry.getValue());
        }
        return cursor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XsetDirective)) {
            return false;
        }
        XsetDirective other = (XsetDirective)o;
        Arg this$expr = this.expr;
        Arg other$expr = other.expr;
        return !(this$expr == null ? other$expr != null : !((Object)this$expr).equals(other$expr));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Arg $expr = this.expr;
        result = result * 59 + ($expr == null ? 43 : ((Object)$expr).hashCode());
        return result;
    }
}

