/*
 * Decompiled with CFR 0.152.
 */
package org.xembly;

import java.util.ArrayList;
import lombok.Generated;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xembly.Arg;
import org.xembly.Directive;
import org.xembly.DomCursor;
import org.xembly.XmlContentException;

final class AddIfDirective
implements Directive {
    private final Arg name;

    AddIfDirective(String node) throws XmlContentException {
        this.name = new Arg(node);
    }

    public String toString() {
        return String.format("ADDIF %s", this.name);
    }

    @Override
    public Directive.Cursor exec(Node dom, Directive.Cursor cursor, Directive.Stack stack) {
        ArrayList<Node> targets = new ArrayList<Node>(cursor.size());
        String label = this.name.raw();
        for (Node node : cursor) {
            NodeList kids = node.getChildNodes();
            Node target = null;
            int len = kids.getLength();
            for (int idx = 0; idx < len; ++idx) {
                if (kids.item(idx).getNodeName().compareToIgnoreCase(label) != 0) continue;
                target = kids.item(idx);
                break;
            }
            if (target == null) {
                Document doc = dom.getOwnerDocument() == null ? (Document)Document.class.cast(dom) : dom.getOwnerDocument();
                target = doc.createElement(this.name.raw());
                node.appendChild(target);
            }
            targets.add(target);
        }
        return new DomCursor(targets);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddIfDirective)) {
            return false;
        }
        AddIfDirective other = (AddIfDirective)o;
        Arg this$name = this.name;
        Arg other$name = other.name;
        return !(this$name == null ? other$name != null : !((Object)this$name).equals(other$name));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Arg $name = this.name;
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        return result;
    }
}

