/*
 * Decompiled with CFR 0.152.
 */
package org.xembly;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.xembly.AddDirective;
import org.xembly.AddIfDirective;
import org.xembly.Arg;
import org.xembly.AttrDirective;
import org.xembly.Callback;
import org.xembly.CdataDirective;
import org.xembly.CommentDirective;
import org.xembly.Directive;
import org.xembly.ParsingException;
import org.xembly.PiDirective;
import org.xembly.PopDirective;
import org.xembly.PushDirective;
import org.xembly.RemoveDirective;
import org.xembly.SetDirective;
import org.xembly.StrictDirective;
import org.xembly.SyntaxException;
import org.xembly.UpDirective;
import org.xembly.XattrDirective;
import org.xembly.XmlContentException;
import org.xembly.XpathDirective;
import org.xembly.XsetDirective;

final class Verbs {
    private static final Map<String, Callback<Directive>> ARGUMENTLESS = new HashMap<String, Callback<Directive>>(){
        {
            this.put("REMOVE", RemoveDirective::new);
            this.put("UP", UpDirective::new);
            this.put("PUSH", PushDirective::new);
            this.put("POP", PopDirective::new);
        }
    };
    private static final Map<String, Function<String, Callback<Directive>>> SIMPLE = new HashMap<String, Function<String, Callback<Directive>>>(){
        {
            this.put("XPATH", value -> () -> new XpathDirective((String)value));
            this.put("SET", value -> () -> new SetDirective((String)value));
            this.put("XSET", value -> () -> new XsetDirective((String)value));
            this.put("ADD", value -> () -> new AddDirective((String)value));
            this.put("ADDIF", value -> () -> new AddIfDirective((String)value));
            this.put("STRICT", value -> () -> new StrictDirective(Integer.parseInt(value)));
            this.put("CDATA", value -> () -> new CdataDirective((String)value));
            this.put("COMMENT", value -> () -> new CommentDirective((String)value));
        }
    };
    private static final Map<String, BiFunction<String, String, Callback<Directive>>> COMPLEX = new HashMap<String, BiFunction<String, String, Callback<Directive>>>(){
        {
            this.put("ATTR", (attr, value) -> () -> new AttrDirective((String)attr, (String)value));
            this.put("XATTR", (attr, value) -> () -> new XattrDirective((String)attr, (String)value));
            this.put("PI", (target, data) -> () -> new PiDirective((String)target, (String)data));
        }
    };
    private final String text;
    private final Collection<Directive> dirs;

    Verbs(String txt) {
        this.text = txt;
        this.dirs = new LinkedList<Directive>();
    }

    public Iterable<Directive> directives() {
        String trimmed = this.text.trim();
        if (!trimmed.isEmpty()) {
            String semicolon = ";";
            StringBuilder builder = new StringBuilder();
            try {
                for (String part : trimmed.split(";")) {
                    if (builder.length() == 0) {
                        builder.append(Verbs.ltrim(part));
                    } else {
                        builder.append(part);
                    }
                    Optional<Callback<Directive>> command = Verbs.parsedCommand(builder.toString());
                    if (command.isPresent()) {
                        this.dirs.add(command.get().call());
                        builder.setLength(0);
                        continue;
                    }
                    builder.append(";");
                }
            }
            catch (ParsingException | XmlContentException ex) {
                throw new SyntaxException(String.format("Parsing failed as %s: \"%s\"", ex.getClass().getCanonicalName(), ex.getLocalizedMessage()), ex);
            }
        }
        return this.dirs;
    }

    private static Optional<Callback<Directive>> parsedCommand(String part) throws XmlContentException, ParsingException {
        Optional<Callback<Directive>> cmd;
        String trimmed = Verbs.withoutNumber(part.trim());
        if (ARGUMENTLESS.containsKey(trimmed)) {
            cmd = Optional.of(ARGUMENTLESS.get(trimmed));
        } else {
            int index = Verbs.nearQuoteIndex(part);
            String command = Verbs.withoutNumber(part.substring(0, index).trim());
            if (SIMPLE.containsKey(command)) {
                cmd = Verbs.simpleCommand(part, command, index);
            } else if (COMPLEX.containsKey(command)) {
                cmd = Verbs.complexCommand(part, command, index);
            } else {
                throw new ParsingException(String.format("Unknown command near [%s;]", part));
            }
        }
        return cmd;
    }

    private static String withoutNumber(String command) {
        int index = command.indexOf(58);
        String cmd = index == -1 ? command : Verbs.ltrim(command.substring(index + 1));
        return cmd;
    }

    private static int nearQuoteIndex(String part) throws ParsingException {
        int index;
        int single = part.indexOf(39);
        int dual = part.indexOf(34);
        if (single == -1 && dual == -1) {
            throw new ParsingException(String.format("Couldn't find quote in the part of the command near [%s;]", part));
        }
        if (single != -1 && (dual == -1 || single < dual)) {
            index = single;
        } else if (single == -1 || dual < single) {
            index = dual;
        } else {
            throw new ParsingException(String.format("Unexpected behaviour when searching for quotes near [%s;]", part));
        }
        return index;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Optional<Callback<Directive>> simpleCommand(String part, String command, int index) throws XmlContentException, ParsingException {
        void var5_9;
        char quote = part.charAt(index);
        String[] args = part.split(String.valueOf(quote));
        if (args.length == 1) {
            Optional optional = Optional.empty();
            return var5_9;
        } else if (args.length == 2) {
            if (part.charAt(part.length() - 1) == quote) {
                Optional<Callback<Directive>> optional = Optional.of(SIMPLE.get(command).apply(Arg.unescape(String.format("'%s'", args[1]))));
                return var5_9;
            } else {
                Optional optional = Optional.empty();
            }
            return var5_9;
        } else {
            if (args.length != 3) throw new ParsingException(String.format("Unexpected behaviour when searching for command arguments [%s;]", part));
            if (!args[2].trim().isEmpty()) throw new ParsingException(String.format("Unexpected symbols after command argument near [%s;]", part));
            Optional<Callback<Directive>> optional = Optional.of(SIMPLE.get(command).apply(Arg.unescape(String.format("'%s'", args[1]))));
        }
        return var5_9;
    }

    private static Optional<Callback<Directive>> complexCommand(String part, String command, int index) throws XmlContentException, ParsingException {
        Optional<Callback<Directive>> cmd;
        char quote = part.charAt(index);
        String[] args = part.split(String.valueOf(quote));
        if (args.length == 1) {
            cmd = Optional.empty();
        } else if (args.length == 2) {
            if (part.charAt(part.length() - 1) == quote) {
                throw new ParsingException(String.format("Unexpected last quote near [%s;]", part));
            }
            cmd = Optional.empty();
        } else if (args.length > 2) {
            String tail = Verbs.ltrim(part.substring(index + part.substring(index + 1).indexOf(quote) + 2));
            if (tail.isEmpty()) {
                cmd = Optional.empty();
            } else {
                if (tail.charAt(0) != ',') {
                    throw new ParsingException(String.format("Comma after first argument is expected near [%s;]", part));
                }
                if ((tail = Verbs.ltrim(tail.substring(1))).isEmpty()) {
                    throw new ParsingException(String.format("Unexpected last semicolon near [%s;]", part));
                }
                char first = tail.charAt(0);
                if (first != '\'' && first != '\"') {
                    throw new ParsingException(String.format("Single or double quote is expected after comma near [%s;]", part));
                }
                int next = (tail = tail.substring(1)).indexOf(first);
                if (next == -1) {
                    cmd = Optional.empty();
                } else {
                    if (!tail.substring(next + 1).trim().isEmpty()) {
                        throw new ParsingException(String.format("Unexpected symbols after second argument near [%s;]", part));
                    }
                    cmd = Optional.of(COMPLEX.get(command).apply(Arg.unescape(String.format("'%s'", args[1])), Arg.unescape(String.format("'%s'", tail.substring(0, next)))));
                }
            }
        } else {
            throw new ParsingException(String.format("Unexpected behaviour when searching for command arguments [%s;]", part));
        }
        return cmd;
    }

    private static String ltrim(String str) {
        int idx;
        for (idx = 0; idx < str.length() && Character.isWhitespace(str.charAt(idx)); ++idx) {
        }
        return str.substring(idx);
    }
}

