/*
 * Decompiled with CFR 0.152.
 */
package org.xembly;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import lombok.Generated;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xembly.Arg;
import org.xembly.Directive;
import org.xembly.DomCursor;
import org.xembly.ImpossibleModificationException;
import org.xembly.XmlContentException;

final class XpathDirective
implements Directive {
    private static final ThreadLocal<XPathFactory> FACTORY = ThreadLocal.withInitial(XPathFactory::newInstance);
    private static final Pattern ROOT_ONLY = Pattern.compile("/([^/\\(\\[\\{:]+)");
    private final Arg expr;

    XpathDirective(String path) throws XmlContentException {
        this.expr = new Arg(path);
    }

    public String toString() {
        return String.format("XPATH %s", this.expr);
    }

    @Override
    public Directive.Cursor exec(Node dom, Directive.Cursor cursor, Directive.Stack stack) throws ImpossibleModificationException {
        String query = this.expr.raw();
        Matcher matcher = ROOT_ONLY.matcher(query);
        Collection<Node> targets = matcher.matches() ? XpathDirective.rootOnly(matcher.group(1), dom) : XpathDirective.traditional(query, dom, cursor);
        return new DomCursor(targets);
    }

    private static Collection<Node> rootOnly(String root, Node dom) {
        Element target = dom.getOwnerDocument() == null ? ((Document)Document.class.cast(dom)).getDocumentElement() : dom.getOwnerDocument().getDocumentElement();
        List<Node> targets = root != null && target != null && ("*".equals(root) || target.getNodeName().equals(root)) ? Collections.singletonList(target) : Collections.emptyList();
        return targets;
    }

    private static Collection<Node> traditional(String query, Node dom, Collection<Node> current) throws ImpossibleModificationException {
        XPathFactory factory = FACTORY.get();
        FACTORY.remove();
        XPath xpath = factory.newXPath();
        HashSet<Node> targets = new HashSet<Node>(0);
        for (Node node : XpathDirective.roots(dom, current)) {
            NodeList list;
            try {
                list = (NodeList)NodeList.class.cast(xpath.evaluate(query, node, XPathConstants.NODESET));
            }
            catch (XPathExpressionException ex) {
                throw new ImpossibleModificationException(String.format("Invalid XPath expression '%s'", query), ex);
            }
            XpathDirective.copyTo(list, targets);
        }
        return targets;
    }

    private static void copyTo(NodeList list, Collection<Node> targets) {
        int len = list.getLength();
        for (int idx = 0; idx < len; ++idx) {
            targets.add(list.item(idx));
        }
    }

    private static Iterable<Node> roots(Node dom, Collection<Node> nodes) {
        Collection<Node> roots = nodes.isEmpty() ? (dom.getOwnerDocument() == null ? Collections.singletonList(dom) : Collections.singletonList(dom.getOwnerDocument().getDocumentElement())) : nodes;
        return roots;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XpathDirective)) {
            return false;
        }
        XpathDirective other = (XpathDirective)o;
        Arg this$expr = this.expr;
        Arg other$expr = other.expr;
        return !(this$expr == null ? other$expr != null : !((Object)this$expr).equals(other$expr));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Arg $expr = this.expr;
        result = result * 59 + ($expr == null ? 43 : ((Object)$expr).hashCode());
        return result;
    }
}

