/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.aspects.apt;

import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"com.jcabi.aspects.Quietly"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public final class QuietlyReturnTypeProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        for (TypeElement typeElement : annotations) {
            this.checkMethods(env, typeElement);
        }
        return true;
    }

    private void checkMethods(RoundEnvironment env, TypeElement type) {
        for (Element element : env.getElementsAnnotatedWith(type)) {
            ExecutableElement method;
            if (element.getKind() != ElementKind.METHOD || (method = (ExecutableElement)element).getReturnType().getKind().equals((Object)TypeKind.VOID)) continue;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Method '%s.%s' annotated with @Quietly does not return void", method.getEnclosingElement().getSimpleName(), method.getSimpleName()));
        }
    }
}

