/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.github.Gists;
import com.jcabi.github.Gitignores;
import com.jcabi.github.Limits;
import com.jcabi.github.Markdown;
import com.jcabi.github.Organizations;
import com.jcabi.github.Repos;
import com.jcabi.github.Search;
import com.jcabi.github.Users;
import com.jcabi.http.Request;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import lombok.Generated;

@Immutable
public interface GitHub {
    public Request entry();

    public Repos repos();

    public Gists gists();

    public Users users();

    public Organizations organizations();

    public Markdown markdown();

    public Limits limits();

    public Search search();

    public Gitignores gitignores();

    public JsonObject meta() throws IOException;

    public JsonObject emojis() throws IOException;

    @Immutable
    public static final class Time {
        public static final String FORMAT_ISO = "yyyy-MM-dd'T'HH:mm:ss'Z'";
        public static final TimeZone TIMEZONE = TimeZone.getTimeZone("UTC");
        private final transient long msec;

        public Time() {
            this(new Date());
        }

        public Time(String text) throws ParseException {
            this(Time.format().parse(text));
        }

        public Time(Date date) {
            this(date.getTime());
        }

        public Time(long millis) {
            this.msec = millis;
        }

        public String toString() {
            return Time.format().format(this.date());
        }

        public Date date() {
            return new Date(this.msec);
        }

        private static DateFormat format() {
            SimpleDateFormat fmt = new SimpleDateFormat(FORMAT_ISO, Locale.ENGLISH);
            fmt.setTimeZone(TIMEZONE);
            return fmt;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Time)) {
                return false;
            }
            Time other = (Time)o;
            return this.msec == other.msec;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $msec = this.msec;
            result = result * 59 + (int)($msec >>> 32 ^ $msec);
            return result;
        }
    }
}

