/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.google.common.base.Optional;
import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.GitHub;
import com.jcabi.github.JsonReadable;
import com.jcabi.github.Repo;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

@Immutable
public interface Repos {
    public GitHub github();

    public Repo create(RepoCreate var1) throws IOException;

    public Repo get(Coordinates var1);

    public void remove(Coordinates var1) throws IOException;

    public Iterable<Repo> iterate(String var1);

    public boolean exists(Coordinates var1) throws IOException;

    @Loggable(value=1)
    public static final class RepoCreate
    implements JsonReadable {
        private final transient String repo;
        private final transient boolean priv;
        private final transient String descr;
        private final transient String home;
        private final transient Optional<Boolean> init;
        private final transient String organization;
        private final transient Map<String, JsonValue> other;

        public RepoCreate(String nme, boolean prvt) {
            this(nme, prvt, "", "", (Optional<Boolean>)Optional.absent(), "");
        }

        private RepoCreate(String nme, boolean prvt, String desc, String page, Optional<Boolean> auto, String org) {
            if (nme.isEmpty()) {
                throw new IllegalArgumentException("Name cannot be empty!");
            }
            this.repo = nme;
            this.priv = prvt;
            this.descr = desc;
            this.home = page;
            this.init = auto;
            this.organization = org;
            this.other = new HashMap<String, JsonValue>(0);
        }

        public String name() {
            return this.repo;
        }

        public boolean isPrivate() {
            return this.priv;
        }

        public String description() {
            return this.descr;
        }

        public String homepage() {
            return this.home;
        }

        public Optional<Boolean> autoInit() {
            return this.init;
        }

        public String organization() {
            return this.organization;
        }

        public RepoCreate withName(String nme) {
            return new RepoCreate(nme, this.priv, this.descr, this.home, this.init, this.organization);
        }

        public RepoCreate withPrivacy(boolean privacy) {
            return new RepoCreate(this.repo, privacy, this.descr, this.home, this.init, this.organization);
        }

        public RepoCreate withDescription(String desc) {
            return new RepoCreate(this.repo, this.priv, desc, this.home, this.init, this.organization);
        }

        public RepoCreate withHomepage(String page) {
            return new RepoCreate(this.repo, this.priv, this.descr, page, this.init, this.organization);
        }

        public RepoCreate withAutoInit(Optional<Boolean> auto) {
            return new RepoCreate(this.repo, this.priv, this.descr, this.home, auto, this.organization);
        }

        public RepoCreate withAutoInit(boolean auto) {
            return new RepoCreate(this.repo, this.priv, this.descr, this.home, (Optional<Boolean>)Optional.of((Object)auto), this.organization);
        }

        public RepoCreate withOrganization(String org) {
            return new RepoCreate(this.repo, this.priv, this.descr, this.home, this.init, org);
        }

        public RepoCreate with(String key, JsonValue value) {
            this.other.put(key, value);
            return this;
        }

        @Override
        public JsonObject json() {
            JsonObjectBuilder builder = Json.createObjectBuilder().add("name", this.repo).add("description", this.descr).add("homepage", this.home).add("private", this.priv);
            if (this.init.isPresent()) {
                builder = builder.add("auto_init", ((Boolean)this.init.get()).booleanValue());
            }
            for (Map.Entry<String, JsonValue> entry : this.other.entrySet()) {
                builder.add(entry.getKey(), entry.getValue());
            }
            return builder.build();
        }

        @Generated
        public String toString() {
            return "Repos.RepoCreate(repo=" + this.repo + ", priv=" + this.priv + ", descr=" + this.descr + ", home=" + this.home + ", init=" + this.init + ", organization=" + this.organization + ", other=" + this.other + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RepoCreate)) {
                return false;
            }
            RepoCreate other = (RepoCreate)o;
            if (this.priv != other.priv) {
                return false;
            }
            String this$repo = this.repo;
            String other$repo = other.repo;
            if (this$repo == null ? other$repo != null : !this$repo.equals(other$repo)) {
                return false;
            }
            String this$descr = this.descr;
            String other$descr = other.descr;
            if (this$descr == null ? other$descr != null : !this$descr.equals(other$descr)) {
                return false;
            }
            String this$home = this.home;
            String other$home = other.home;
            if (this$home == null ? other$home != null : !this$home.equals(other$home)) {
                return false;
            }
            Optional<Boolean> this$init = this.init;
            Optional<Boolean> other$init = other.init;
            return !(this$init == null ? other$init != null : !this$init.equals(other$init));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.priv ? 79 : 97);
            String $repo = this.repo;
            result = result * 59 + ($repo == null ? 43 : $repo.hashCode());
            String $descr = this.descr;
            result = result * 59 + ($descr == null ? 43 : $descr.hashCode());
            String $home = this.home;
            result = result * 59 + ($home == null ? 43 : $home.hashCode());
            Optional<Boolean> $init = this.init;
            result = result * 59 + ($init == null ? 43 : $init.hashCode());
            return result;
        }
    }
}

