/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Assignees;
import com.jcabi.github.Branch;
import com.jcabi.github.Branches;
import com.jcabi.github.Collaborators;
import com.jcabi.github.Contents;
import com.jcabi.github.Coordinates;
import com.jcabi.github.DeployKeys;
import com.jcabi.github.Forks;
import com.jcabi.github.Git;
import com.jcabi.github.GitHub;
import com.jcabi.github.Hooks;
import com.jcabi.github.IssueEvents;
import com.jcabi.github.Issues;
import com.jcabi.github.Labels;
import com.jcabi.github.Language;
import com.jcabi.github.Milestones;
import com.jcabi.github.Notifications;
import com.jcabi.github.Pulls;
import com.jcabi.github.Releases;
import com.jcabi.github.Repo;
import com.jcabi.github.RepoCommits;
import com.jcabi.github.RtAssignees;
import com.jcabi.github.RtBranch;
import com.jcabi.github.RtBranches;
import com.jcabi.github.RtCollaborators;
import com.jcabi.github.RtContents;
import com.jcabi.github.RtDeployKeys;
import com.jcabi.github.RtForks;
import com.jcabi.github.RtGit;
import com.jcabi.github.RtHooks;
import com.jcabi.github.RtIssueEvents;
import com.jcabi.github.RtIssues;
import com.jcabi.github.RtJson;
import com.jcabi.github.RtLabels;
import com.jcabi.github.RtLanguage;
import com.jcabi.github.RtMilestones;
import com.jcabi.github.RtNotifications;
import com.jcabi.github.RtPulls;
import com.jcabi.github.RtReleases;
import com.jcabi.github.RtRepoCommits;
import com.jcabi.github.RtStargazers;
import com.jcabi.github.RtStars;
import com.jcabi.github.Stargazers;
import com.jcabi.github.Stars;
import com.jcabi.http.Request;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import lombok.Generated;

@Immutable
@Loggable(value=1)
final class RtRepo
implements Repo {
    private final transient GitHub ghub;
    private final transient Request entry;
    private final transient Request request;
    private final transient Coordinates coords;

    RtRepo(GitHub github, Request req, Coordinates crd) {
        this.ghub = github;
        this.entry = req;
        this.coords = crd;
        this.request = this.entry.uri().path("/repos").path(this.coords.user()).path(this.coords.repo()).back();
    }

    public String toString() {
        return this.coords.toString();
    }

    @Override
    public GitHub github() {
        return this.ghub;
    }

    @Override
    public Coordinates coordinates() {
        return this.coords;
    }

    @Override
    public Issues issues() {
        return new RtIssues(this.entry, this);
    }

    @Override
    public Milestones milestones() {
        return new RtMilestones(this.entry, this);
    }

    @Override
    public Pulls pulls() {
        return new RtPulls(this.entry, this);
    }

    @Override
    public Hooks hooks() {
        return new RtHooks(this.entry, this);
    }

    @Override
    public IssueEvents issueEvents() {
        return new RtIssueEvents(this.entry, this);
    }

    @Override
    public Labels labels() {
        return new RtLabels(this.entry, this);
    }

    @Override
    public Assignees assignees() {
        return new RtAssignees(this.entry, this);
    }

    @Override
    public Releases releases() {
        return new RtReleases(this.entry, this);
    }

    @Override
    public DeployKeys keys() {
        return new RtDeployKeys(this.entry, this);
    }

    @Override
    public Forks forks() {
        return new RtForks(this.entry, this);
    }

    @Override
    public Contents contents() {
        return new RtContents(this.entry, this);
    }

    @Override
    public Collaborators collaborators() {
        return new RtCollaborators(this.entry, this);
    }

    @Override
    public Git git() {
        return new RtGit(this.entry, this);
    }

    @Override
    public Stars stars() {
        return new RtStars(this.entry, this);
    }

    @Override
    public Notifications notifications() {
        return new RtNotifications(this.request.uri().path("notifications").back());
    }

    @Override
    public Iterable<Language> languages() throws IOException {
        RtJson json = new RtJson(this.request.uri().path("/languages").back());
        JsonObject object = json.fetch();
        ArrayList<Language> languages = new ArrayList<Language>(object.size());
        for (Map.Entry value : object.entrySet()) {
            String name = (String)value.getKey();
            languages.add(new RtLanguage(name, object.getJsonNumber(name).longValue()));
        }
        return languages;
    }

    @Override
    public Branch defaultBranch() throws IOException {
        return new RtBranch(this.request, this, this.json().getString("default_branch"), "");
    }

    @Override
    public Stargazers stargazers() {
        return new RtStargazers(this.request);
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new RtJson(this.request).patch(json);
    }

    @Override
    public RepoCommits commits() {
        return new RtRepoCommits(this.entry, this);
    }

    @Override
    public Branches branches() {
        return new RtBranches(this.entry, this);
    }

    @Override
    public JsonObject json() throws IOException {
        return new RtJson(this.request).fetch();
    }

    @Override
    public int compareTo(Repo repo) {
        return this.coords.compareTo(repo.coordinates());
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtRepo)) {
            return false;
        }
        RtRepo other = (RtRepo)o;
        GitHub this$ghub = this.ghub;
        GitHub other$ghub = other.ghub;
        if (this$ghub == null ? other$ghub != null : !this$ghub.equals(other$ghub)) {
            return false;
        }
        Request this$entry = this.entry;
        Request other$entry = other.entry;
        if (this$entry == null ? other$entry != null : !this$entry.equals(other$entry)) {
            return false;
        }
        Coordinates this$coords = this.coords;
        Coordinates other$coords = other.coords;
        return !(this$coords == null ? other$coords != null : !this$coords.equals(other$coords));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GitHub $ghub = this.ghub;
        result = result * 59 + ($ghub == null ? 43 : $ghub.hashCode());
        Request $entry = this.entry;
        result = result * 59 + ($entry == null ? 43 : $entry.hashCode());
        Coordinates $coords = this.coords;
        result = result * 59 + ($coords == null ? 43 : $coords.hashCode());
        return result;
    }
}

