/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Repo;
import com.jcabi.github.RtJson;
import com.jcabi.github.Tree;
import com.jcabi.http.Request;
import jakarta.json.JsonObject;
import java.io.IOException;

@Immutable
@Loggable(value=1)
final class RtTree
implements Tree {
    private final transient Request request;
    private final transient Repo owner;
    private final transient String hash;

    RtTree(Request req, Repo repo, String sha) {
        Coordinates coords = repo.coordinates();
        this.request = req.uri().path("/repos").path(coords.user()).path(coords.repo()).path("/git").path("/trees").path(sha).back();
        this.owner = repo;
        this.hash = sha;
    }

    public String toString() {
        return this.request.uri().get().toString();
    }

    @Override
    public Repo repo() {
        return this.owner;
    }

    @Override
    public String sha() {
        return this.hash;
    }

    @Override
    public JsonObject json() throws IOException {
        return new RtJson(this.request).fetch();
    }

    public boolean equals(Object obj) {
        boolean result;
        if (this == obj) {
            result = true;
        } else if (obj == null || this.getClass() != obj.getClass()) {
            result = false;
        } else {
            RtTree other = (RtTree)obj;
            result = this.request.equals(other.request) && this.owner.equals(other.owner) && this.hash.equals(other.hash);
        }
        return result;
    }

    public int hashCode() {
        int result = this.request.hashCode();
        result = 31 * result + this.owner.hashCode();
        result = 31 * result + this.hash.hashCode();
        return result;
    }
}

