/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.JsonReadable;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.IOException;
import lombok.Generated;

@Immutable
@Loggable(value=1)
final class SmartJson {
    private final transient JsonReadable object;

    SmartJson(JsonReadable obj) {
        this.object = obj;
    }

    public String text(String name) throws IOException {
        return this.value(name, JsonString.class).getString();
    }

    public int number(String name) throws IOException {
        return this.value(name, JsonNumber.class).intValue();
    }

    public JsonObject json() throws IOException {
        return this.object.json();
    }

    public <T> T value(String name, Class<T> type) throws IOException {
        JsonObject json = this.json();
        if (!json.containsKey((Object)name)) {
            throw new IllegalStateException(String.format("'%s' is absent in JSON: %s", name, json));
        }
        JsonValue value = (JsonValue)json.get((Object)name);
        if (value == null) {
            throw new IllegalStateException(String.format("'%s' is NULL in %s", name, json));
        }
        if (value.getClass().isAssignableFrom(type)) {
            throw new IllegalStateException(String.format("'%s' is not of type %s", name, type));
        }
        return type.cast(value);
    }

    public boolean hasNotNull(String name) throws IOException {
        JsonValue value = (JsonValue)this.object.json().get((Object)name);
        return value != null && !JsonValue.ValueType.NULL.equals((Object)value.getValueType());
    }

    @Generated
    public String toString() {
        return "SmartJson(object=" + this.object + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SmartJson)) {
            return false;
        }
        SmartJson other = (SmartJson)o;
        JsonReadable this$object = this.object;
        JsonReadable other$object = other.object;
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JsonReadable $object = this.object;
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        return result;
    }
}

