/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Pull;
import com.jcabi.github.PullComment;
import com.jcabi.github.Reaction;
import com.jcabi.github.mock.JsonNode;
import com.jcabi.github.mock.JsonPatch;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.xml.XML;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.util.Collection;
import lombok.Generated;

@Immutable
final class MkPullComment
implements PullComment {
    private final transient MkStorage storage;
    private final transient Coordinates repo;
    private final transient Pull owner;
    private final transient int num;

    MkPullComment(MkStorage stg, Coordinates rep, Pull pull, int number) {
        this.storage = stg;
        this.repo = rep;
        this.owner = pull;
        this.num = number;
    }

    @Override
    public JsonObject json() throws IOException {
        return new JsonNode((XML)this.storage.xml().nodes(this.xpath()).get(0)).json();
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new JsonPatch(this.storage).patch(this.xpath(), json);
    }

    @Override
    public Pull pull() {
        return this.owner;
    }

    @Override
    public int number() {
        return this.num;
    }

    @Override
    public void react(Reaction reaction) {
        throw new UnsupportedOperationException("React not implemented");
    }

    @Override
    public Collection<Reaction> reactions() {
        throw new UnsupportedOperationException("reactions() not implemented");
    }

    @Override
    public int compareTo(PullComment other) {
        return this.number() - other.number();
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/pulls/pull[number='%d']/comments/comment[id='%d']", this.repo, this.owner.number(), this.num);
    }

    @Generated
    public String toString() {
        return "MkPullComment(storage=" + this.storage + ", repo=" + this.repo + ", owner=" + this.owner + ", num=" + this.num + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkPullComment)) {
            return false;
        }
        MkPullComment other = (MkPullComment)o;
        if (this.num != other.num) {
            return false;
        }
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        Coordinates this$repo = this.repo;
        Coordinates other$repo = other.repo;
        if (this$repo == null ? other$repo != null : !this$repo.equals(other$repo)) {
            return false;
        }
        Pull this$owner = this.owner;
        Pull other$owner = other.owner;
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.num;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        Coordinates $repo = this.repo;
        result = result * 59 + ($repo == null ? 43 : $repo.hashCode());
        Pull $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }
}

