/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.safe;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Comment;
import com.jcabi.github.Issue;
import com.jcabi.github.Reaction;
import com.jcabi.github.mock.MkGitHub;
import com.jcabi.github.safe.SfIssue;
import com.jcabi.log.Logger;
import jakarta.json.JsonObject;
import java.io.IOException;
import lombok.Generated;

@Immutable
@Loggable(value=1)
public final class SfComment
implements Comment {
    private final transient Comment origin;

    public SfComment(Comment cmt) {
        this.origin = cmt;
    }

    public String toString() {
        return this.origin.toString();
    }

    @Override
    public Issue issue() {
        return this.origin.issue();
    }

    @Override
    public long number() {
        return this.origin.number();
    }

    @Override
    public void remove() throws IOException {
        try {
            this.origin.remove();
        }
        catch (AssertionError ex) {
            Logger.warn((Object)this, (String)"Failed to remove comment: %[exception]s", (Object[])new Object[]{ex});
        }
    }

    @Override
    public void react(Reaction reaction) throws IOException {
        this.origin.react(reaction);
    }

    @Override
    public Iterable<Reaction> reactions() {
        return this.origin.reactions();
    }

    @Override
    public int compareTo(Comment cmt) {
        return this.origin.compareTo(cmt);
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        try {
            this.origin.patch(json);
        }
        catch (AssertionError ex) {
            Logger.warn((Object)this, (String)"Failed to path comment: %[exception]s", (Object[])new Object[]{ex});
        }
    }

    @Override
    public JsonObject json() throws IOException {
        JsonObject json;
        try {
            json = this.origin.json();
        }
        catch (AssertionError ex) {
            String author = new Issue.Smart(new SfIssue(this.origin.issue())).author().login();
            json = new MkGitHub(author).randomRepo().issues().create("", "").comments().post("deleted comment").json();
            Logger.warn((Object)this, (String)"failed to fetch comment: %[exception]s", (Object[])new Object[]{ex});
        }
        return json;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SfComment)) {
            return false;
        }
        SfComment other = (SfComment)o;
        Comment this$origin = this.origin;
        Comment other$origin = other.origin;
        return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Comment $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        return result;
    }
}

