/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.github.Commit;
import com.jcabi.github.Coordinates;
import com.jcabi.github.RtJson;
import com.jcabi.github.RtStatus;
import com.jcabi.github.Status;
import com.jcabi.github.Statuses;
import com.jcabi.http.Request;
import com.jcabi.http.response.JsonResponse;
import com.jcabi.http.response.RestResponse;
import java.io.IOException;
import javax.json.JsonObject;
import javax.json.JsonStructure;

public class RtStatuses
implements Statuses {
    private final transient Request request;
    private final transient Commit cmmt;

    RtStatuses(Request req, Commit commit) {
        Coordinates coords = commit.repo().coordinates();
        this.request = req.uri().path("/repos").path(coords.user()).path(coords.repo()).path("/statuses").path(commit.sha()).back();
        this.cmmt = commit;
    }

    public final String toString() {
        return this.request.uri().get().toString();
    }

    @Override
    public final Commit commit() {
        return this.cmmt;
    }

    @Override
    public final Status create(Statuses.StatusCreate status) throws IOException {
        JsonObject response = ((JsonResponse)((RestResponse)this.request.method("POST").body().set((JsonStructure)status.json()).back().fetch().as(RestResponse.class)).assertStatus(201).as(JsonResponse.class)).json().readObject();
        return new RtStatus(this.cmmt, response);
    }

    @Override
    public final Iterable<Status> list(String ref) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public final JsonObject json() throws IOException {
        return new RtJson(this.request).fetch();
    }
}

