/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.google.common.collect.ImmutableList;
import com.jcabi.github.Check;
import com.jcabi.github.Checks;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Pull;
import com.jcabi.github.mock.MkCheck;
import com.jcabi.github.mock.MkIterable;
import com.jcabi.github.mock.MkStorage;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Collection;
import org.xembly.Directive;
import org.xembly.Directives;

public final class MkChecks
implements Checks {
    private final transient MkStorage storage;
    private final transient Coordinates coordinates;
    private final transient Pull pull;

    MkChecks(MkStorage strg, Coordinates coord, Pull pll) {
        this.storage = strg;
        this.coordinates = coord;
        this.pull = pll;
    }

    public Collection<Check> all() throws IOException {
        return ImmutableList.copyOf(new MkIterable<MkCheck>(this.storage, String.format("%s/check", this.xpath()), item -> new MkCheck(this.storage, this.coordinates, this.pull, Integer.parseInt((String)item.xpath("@id").get(0)))));
    }

    public Check create(Check.Status status, Check.Conclusion conclusion) throws IOException {
        int identifier = new SecureRandom().nextInt();
        Directives directives = new Directives().xpath((Object)this.xpath()).add((Object)"check").attr((Object)"id", (Object)identifier).attr((Object)"status", (Object)status.value()).attr((Object)"conclusion", (Object)conclusion.value()).up();
        this.storage.apply((Iterable<Directive>)directives);
        return new MkCheck(this.storage, this.coordinates, this.pull, identifier);
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/pulls/pull[number='%d']/checks", this.coordinates, this.pull.number());
    }
}

