/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Repo;
import com.jcabi.github.Stars;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkStorage;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.xembly.Directive;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkStars
implements Stars {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;

    MkStars(MkStorage stg, String login, Coordinates rep) throws IOException {
        this.storage = stg;
        this.self = login;
        this.coords = rep;
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)"/github/repos/repo").addIf((Object)"stars"));
    }

    @Override
    public Repo repo() {
        return new MkRepo(this.storage, this.self, this.coords);
    }

    @Override
    public boolean starred() throws IOException {
        List xpath = this.storage.xml().xpath(String.format("%s/star/login/text()", this.xpath()));
        return !xpath.isEmpty() && StringUtils.equalsIgnoreCase((CharSequence)this.self, (CharSequence)((CharSequence)xpath.get(0)));
    }

    @Override
    public void star() throws IOException {
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)this.xpath()).add((Object)"star").add((Object)"login").set((Object)this.self));
    }

    @Override
    public void unstar() throws IOException {
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)this.xpath()).xpath((Object)String.format("star/login[.='%s']", this.self)).remove());
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/stars", this.coords);
    }

    public String toString() {
        return "MkStars(storage=" + this.storage + ", self=" + this.self + ", coords=" + this.coords + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkStars)) {
            return false;
        }
        MkStars other = (MkStars)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        Coordinates this$coords = this.coords;
        Coordinates other$coords = other.coords;
        return !(this$coords == null ? other$coords != null : !this$coords.equals(other$coords));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        Coordinates $coords = this.coords;
        result = result * 59 + ($coords == null ? 43 : $coords.hashCode());
        return result;
    }
}

