/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.request;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.http.ImmutableHeader;
import com.jcabi.http.Request;
import com.jcabi.http.RequestBody;
import com.jcabi.http.RequestURI;
import com.jcabi.http.Response;
import com.jcabi.http.Wire;
import com.jcabi.http.request.BaseRequest;
import com.jcabi.http.request.DefaultResponse;
import com.jcabi.immutable.Array;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@Immutable
@Loggable(value=1)
public final class JdkRequest
implements Request {
    private static final Wire WIRE = new Wire(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Response send(Request req, String home, String method, Collection<Map.Entry<String, String>> headers, InputStream content, int connect, int read) throws IOException {
            URLConnection raw = new URL(home).openConnection();
            if (!(raw instanceof HttpURLConnection)) {
                throw new IOException(String.format("'%s' opens %s instead of expected HttpURLConnection", home, raw.getClass().getName()));
            }
            HttpURLConnection conn = (HttpURLConnection)HttpURLConnection.class.cast(raw);
            try {
                Object output;
                conn.setConnectTimeout(connect);
                conn.setReadTimeout(read);
                conn.setRequestMethod(method);
                conn.setUseCaches(false);
                conn.setInstanceFollowRedirects(false);
                for (Map.Entry<String, String> header : headers) {
                    conn.addRequestProperty(header.getKey(), header.getValue());
                }
                if (method.equals("POST") || method.equals("PUT") || method.equals("PATCH")) {
                    conn.setDoOutput(true);
                    output = conn.getOutputStream();
                    try {
                        this.writeFully(content, (OutputStream)output);
                    }
                    finally {
                        ((OutputStream)output).close();
                        content.close();
                    }
                }
                output = new DefaultResponse(req, conn.getResponseCode(), conn.getResponseMessage(), this.headers(conn.getHeaderFields()), this.body(conn));
                return output;
            }
            catch (IOException exp) {
                throw new IOException(String.format("Failed %s request to %s", method, home), exp);
            }
            finally {
                conn.disconnect();
            }
        }

        private void writeFully(InputStream content, OutputStream output) throws IOException {
            byte[] buffer = new byte[8192];
            int bytes = content.read(buffer);
            while (bytes != -1) {
                output.write(buffer, 0, bytes);
                bytes = content.read(buffer);
            }
        }

        private Array<Map.Entry<String, String>> headers(Map<String, List<String>> fields) {
            LinkedList<ImmutableHeader> headers = new LinkedList<ImmutableHeader>();
            for (Map.Entry<String, List<String>> field : fields.entrySet()) {
                if (field.getKey() == null) continue;
                for (String value : field.getValue()) {
                    headers.add(new ImmutableHeader(field.getKey(), value));
                }
            }
            return new Array(headers);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] body(HttpURLConnection conn) throws IOException {
            byte[] body;
            InputStream input = conn.getResponseCode() >= 400 ? conn.getErrorStream() : conn.getInputStream();
            if (input == null) {
                body = new byte[]{};
            } else {
                try {
                    byte[] buffer = new byte[8192];
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    int bytes = input.read(buffer);
                    while (bytes != -1) {
                        output.write(buffer, 0, bytes);
                        bytes = input.read(buffer);
                    }
                    body = output.toByteArray();
                }
                finally {
                    input.close();
                }
            }
            return body;
        }
    };
    private final transient Request base;

    public JdkRequest(URL url) {
        this(url.toString());
    }

    public JdkRequest(URI uri) {
        this(uri.toString());
    }

    public JdkRequest(String uri) {
        this.base = new BaseRequest(WIRE, uri);
    }

    @Override
    public RequestURI uri() {
        return this.base.uri();
    }

    @Override
    public Request header(String name, Object value) {
        return this.base.header(name, value);
    }

    @Override
    public Request reset(String name) {
        return this.base.reset(name);
    }

    @Override
    public RequestBody body() {
        return this.base.body();
    }

    @Override
    public RequestBody multipartBody() {
        return this.base.multipartBody();
    }

    @Override
    public Request method(String method) {
        return this.base.method(method);
    }

    @Override
    public Request timeout(int connect, int read) {
        return this.base.timeout(connect, read);
    }

    @Override
    public Response fetch() throws IOException {
        return this.base.fetch();
    }

    @Override
    public Response fetch(InputStream stream) throws IOException {
        return this.base.fetch(stream);
    }

    @Override
    public <T extends Wire> Request through(Class<T> type, Object ... args) {
        return this.base.through(type, args);
    }

    @Override
    public Request through(Wire wire) {
        return this.base.through(wire);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdkRequest)) {
            return false;
        }
        JdkRequest other = (JdkRequest)o;
        Request this$base = this.base;
        Request other$base = other.base;
        return !(this$base == null ? other$base != null : !this$base.equals(other$base));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $base = this.base;
        result = result * 59 + ($base == null ? 43 : $base.hashCode());
        return result;
    }

    public String toString() {
        return "JdkRequest(base=" + this.base + ")";
    }
}

