/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.wire;

import com.jcabi.aspects.Immutable;
import com.jcabi.http.Request;
import com.jcabi.http.Response;
import com.jcabi.http.Wire;
import com.jcabi.http.wire.FcCache;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Map;

@Immutable
public final class FcWire
implements Wire {
    private final transient FcCache cache;
    private final transient Wire origin;
    private final transient String regex;

    public FcWire(Wire wire) {
        this(wire, "$never");
    }

    public FcWire(Wire wire, String flsh) {
        this(wire, flsh, new FcCache());
    }

    public FcWire(Wire wire, String flsh, String path) {
        this(wire, flsh, new FcCache(path));
    }

    public FcWire(Wire wire, String flsh, FcCache fcc) {
        this.origin = wire;
        this.regex = flsh;
        this.cache = fcc;
    }

    @Override
    public Response send(Request req, String home, String method, Collection<Map.Entry<String, String>> headers, InputStream content, int connect, int read) throws IOException {
        URI uri = req.uri().get();
        StringBuilder label = new StringBuilder(100).append(method).append(' ').append(uri.getPath());
        if (uri.getQuery() != null) {
            label.append('?').append(uri.getQuery());
        }
        if (label.toString().matches(this.regex)) {
            this.cache.invalidate();
        }
        Response rsp = method.equals("GET") ? this.cache.get(label.toString(), this.origin, req, home, method, headers, content, connect, read) : this.origin.send(req, home, method, headers, content, connect, read);
        return rsp;
    }

    public String toString() {
        return "FcWire(cache=" + this.cache + ", origin=" + this.origin + ", regex=" + this.regex + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FcWire)) {
            return false;
        }
        FcWire other = (FcWire)o;
        Wire this$origin = this.origin;
        Wire other$origin = other.origin;
        if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
            return false;
        }
        String this$regex = this.regex;
        String other$regex = other.regex;
        return !(this$regex == null ? other$regex != null : !this$regex.equals(other$regex));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Wire $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        String $regex = this.regex;
        result = result * 59 + ($regex == null ? 43 : $regex.hashCode());
        return result;
    }
}

