/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.http.ImmutableHeader;
import com.jcabi.http.mock.MkQuery;
import com.jcabi.immutable.ArrayMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.server.Request;

@Immutable
final class GrizzlyQuery
implements MkQuery {
    private final transient Method mtd;
    @Immutable.Array
    private final transient byte[] content;
    private final transient String home;
    private final transient ArrayMap<String, List<String>> hdrs;

    GrizzlyQuery(Request request) throws IOException {
        request.setCharacterEncoding(StandardCharsets.UTF_8.toString());
        this.home = GrizzlyQuery.uri(request);
        this.mtd = request.getMethod();
        this.hdrs = GrizzlyQuery.headers(request);
        this.content = GrizzlyQuery.input(request);
    }

    @Override
    public URI uri() {
        return URI.create(this.home);
    }

    @Override
    public String method() {
        return this.mtd.getMethodString();
    }

    @Override
    public Map<String, List<String>> headers() {
        return Collections.unmodifiableMap(this.hdrs);
    }

    @Override
    public String body() {
        return new String(this.content, StandardCharsets.UTF_8);
    }

    @Override
    public byte[] binary() {
        return Arrays.copyOf(this.content, this.content.length);
    }

    private static String uri(Request request) {
        StringBuilder uri = new StringBuilder(request.getRequestURI());
        String query = request.getQueryString();
        if (query != null && !query.isEmpty()) {
            uri.append('?').append(query);
        }
        return uri.toString();
    }

    private static ArrayMap<String, List<String>> headers(Request request) {
        ConcurrentHashMap<String, List<String>> headers = new ConcurrentHashMap<String, List<String>>(0);
        Iterable names = request.getHeaderNames();
        for (String name : names) {
            headers.put(ImmutableHeader.normalize(name), GrizzlyQuery.headers(request, name));
        }
        return new ArrayMap(headers);
    }

    private static List<String> headers(Request request, String name) {
        LinkedList<String> list = new LinkedList<String>();
        Iterable values = request.getHeaders(name);
        for (Object value : values) {
            list.add(value.toString());
        }
        return list;
    }

    private static byte[] input(Request req) throws IOException {
        ByteArrayOutputStream output;
        byte[] buffer = new byte[8192];
        try (InputStream input = req.getInputStream();){
            int bytes;
            output = new ByteArrayOutputStream();
            while ((bytes = input.read(buffer)) != -1) {
                output.write(buffer, 0, bytes);
            }
        }
        return output.toByteArray();
    }
}

