/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.mock;

import com.jcabi.aspects.Loggable;
import com.jcabi.http.mock.MkAnswer;
import com.jcabi.http.mock.MkContainer;
import com.jcabi.http.mock.MkGrizzlyAdapter;
import com.jcabi.http.mock.MkQuery;
import com.jcabi.log.Logger;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import lombok.Generated;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsAnything;

@Loggable(value=1)
public final class MkGrizzlyContainer
implements MkContainer {
    private final transient MkGrizzlyAdapter adapter = new MkGrizzlyAdapter();
    private transient HttpServer gws;
    private transient int port;

    @Override
    public MkContainer next(MkAnswer answer) {
        return this.next(answer, (Matcher<MkQuery>)new IsAnything());
    }

    @Override
    public MkContainer next(MkAnswer answer, Matcher<MkQuery> condition) {
        return this.next(answer, condition, 1);
    }

    @Override
    public MkContainer next(MkAnswer answer, Matcher<MkQuery> condition, int count) {
        this.adapter.next(answer, condition, count);
        return this;
    }

    @Override
    public MkQuery take() {
        return this.adapter.take();
    }

    @Override
    public MkQuery take(Matcher<MkAnswer> matcher) {
        return this.adapter.take(matcher);
    }

    @Override
    public Collection<MkQuery> takeAll(Matcher<MkAnswer> matcher) {
        return this.adapter.takeAll(matcher);
    }

    @Override
    public int queries() {
        return this.adapter.queries();
    }

    @Override
    public MkContainer start() throws IOException {
        return this.start(0);
    }

    @Override
    public MkContainer start(int prt) throws IOException {
        if (this.port != 0) {
            throw new IllegalStateException(String.format("already listening on port %d, use #stop() first", this.port));
        }
        this.gws = new HttpServer();
        NetworkListener listener = new NetworkListener("grizzly", "0.0.0.0", prt);
        this.gws.addListener(listener);
        this.gws.getServerConfiguration().setAllowPayloadForUndefinedHttpMethods(true);
        this.gws.getServerConfiguration().addHttpHandler((HttpHandler)this.adapter, new String[]{"/"});
        this.gws.start();
        this.port = listener.getPort();
        Logger.info((Object)this, (String)"started on port #%s", (Object[])new Object[]{this.port});
        return this;
    }

    @Override
    public void stop() {
        if (this.gws != null) {
            this.gws.shutdown();
        }
        Logger.info((Object)this, (String)"stopped on port #%s", (Object[])new Object[]{this.port});
        this.port = 0;
    }

    @Override
    public URI home() {
        return URI.create(String.format("http://localhost:%d/", this.port));
    }

    @Override
    public void close() {
        this.stop();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkGrizzlyContainer)) {
            return false;
        }
        MkGrizzlyContainer other = (MkGrizzlyContainer)o;
        if (this.port != other.port) {
            return false;
        }
        MkGrizzlyAdapter this$adapter = this.adapter;
        MkGrizzlyAdapter other$adapter = other.adapter;
        if (this$adapter == null ? other$adapter != null : !((Object)((Object)this$adapter)).equals((Object)other$adapter)) {
            return false;
        }
        HttpServer this$gws = this.gws;
        HttpServer other$gws = other.gws;
        return !(this$gws == null ? other$gws != null : !this$gws.equals(other$gws));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.port;
        MkGrizzlyAdapter $adapter = this.adapter;
        result = result * 59 + ($adapter == null ? 43 : ((Object)((Object)$adapter)).hashCode());
        HttpServer $gws = this.gws;
        result = result * 59 + ($gws == null ? 43 : $gws.hashCode());
        return result;
    }
}

