/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.request;

import com.fasterxml.jackson.databind.util.ClassUtil;
import com.google.common.base.Joiner;
import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.http.ImmutableHeader;
import com.jcabi.http.Request;
import com.jcabi.http.RequestBody;
import com.jcabi.http.RequestURI;
import com.jcabi.http.Response;
import com.jcabi.http.Wire;
import com.jcabi.http.request.MultipartBodyBuilder;
import com.jcabi.immutable.Array;
import com.jcabi.log.Logger;
import jakarta.json.Json;
import jakarta.json.JsonStructure;
import jakarta.ws.rs.core.UriBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import lombok.Generated;

@Immutable
@Loggable(value=1)
public final class BaseRequest
implements Request {
    private static final String ENCODING = "UTF-8";
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final transient Wire wire;
    private final transient String home;
    private final transient String mtd;
    private final transient int connect;
    private final transient int read;
    private final transient Array<Map.Entry<String, String>> hdrs;
    @Immutable.Array
    private final transient byte[] content;

    public BaseRequest(Wire wre, String uri) {
        this(wre, uri, (Iterable<Map.Entry<String, String>>)new Array(), "GET", EMPTY_BYTE_ARRAY);
    }

    public BaseRequest(Wire wre, String uri, Iterable<Map.Entry<String, String>> headers, String method, byte[] body) {
        this(wre, uri, headers, method, body, 0, 0);
    }

    public BaseRequest(Wire wre, String uri, Iterable<Map.Entry<String, String>> headers, String method, byte[] body, int cnct, int rdd) {
        this.wire = wre;
        this.home = BaseRequest.createUri(uri).toString();
        this.hdrs = new Array(headers);
        this.mtd = method;
        this.content = (byte[])body.clone();
        this.connect = cnct;
        this.read = rdd;
    }

    @Override
    public RequestURI uri() {
        return new BaseUri(this, this.home);
    }

    @Override
    public Request header(String name, Object value) {
        return new BaseRequest(this.wire, this.home, (Iterable<Map.Entry<String, String>>)this.hdrs.with((Object)new ImmutableHeader(name, value.toString())), this.mtd, this.content, this.connect, this.read);
    }

    @Override
    public Request reset(String name) {
        LinkedList<Map.Entry<String, String>> headers = new LinkedList<Map.Entry<String, String>>();
        String key = ImmutableHeader.normalize(name);
        for (Map.Entry header : this.hdrs) {
            if (((String)header.getKey()).equals(key)) continue;
            headers.add(header);
        }
        return new BaseRequest(this.wire, this.home, headers, this.mtd, this.content, this.connect, this.read);
    }

    @Override
    public RequestBody body() {
        return new FormEncodedBody(this, this.content);
    }

    @Override
    public RequestBody multipartBody() {
        return new MultipartFormBody(this, this.content);
    }

    @Override
    public Request method(String method) {
        return new BaseRequest(this.wire, this.home, (Iterable<Map.Entry<String, String>>)this.hdrs, method, this.content, this.connect, this.read);
    }

    @Override
    public Request timeout(int cnct, int rdd) {
        return new BaseRequest(this.wire, this.home, (Iterable<Map.Entry<String, String>>)this.hdrs, this.mtd, this.content, cnct, rdd);
    }

    @Override
    public Response fetch() throws IOException {
        return this.fetchResponse(new ByteArrayInputStream(this.content));
    }

    @Override
    public Response fetch(InputStream stream) throws IOException {
        if (this.content.length > 0) {
            throw new IllegalStateException("Request Body is not empty, use fetch() instead");
        }
        return this.fetchResponse(stream);
    }

    @Override
    public <T extends Wire> Request through(Class<T> type, Object ... args) {
        return this.through(this.mkWire(type, args));
    }

    @Override
    public Request through(Wire wre) {
        return new BaseRequest(wre, this.home, (Iterable<Map.Entry<String, String>>)this.hdrs, this.mtd, this.content, this.connect, this.read);
    }

    public String toString() {
        URI uri = URI.create(this.home);
        StringBuilder text = new StringBuilder("HTTP/1.1 ").append(this.mtd).append(' ').append(uri.getPath()).append(" (").append(uri.getHost()).append(")\n");
        for (Map.Entry header : this.hdrs) {
            text.append(Logger.format((String)"%s: %s\n", (Object[])new Object[]{header.getKey(), header.getValue()}));
        }
        return text.append('\n').append(new RequestBody.Printable(this.content).toString()).toString();
    }

    private <T extends Wire> Wire mkWire(Class<T> type, Object ... args) {
        Wire decorated;
        Constructor<?> ctor = BaseRequest.findCtor(type, args);
        Object[] params = new Object[args.length + 1];
        params[0] = this.wire;
        System.arraycopy(args, 0, params, 1, args.length);
        try {
            decorated = (Wire)Wire.class.cast(ctor.newInstance(params));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            throw new IllegalStateException(ex);
        }
        return decorated;
    }

    private Response fetchResponse(InputStream stream) throws IOException {
        long start = System.currentTimeMillis();
        Response response = this.wire.send(this, this.home, this.mtd, (Collection<Map.Entry<String, String>>)this.hdrs, stream, this.connect, this.read);
        URI uri = URI.create(this.home);
        if (Logger.isInfoEnabled((Object)this)) {
            Logger.info((Object)this, (String)"#fetch(%s %s%s %s): [%d %s] in %[ms]s", (Object[])new Object[]{this.mtd, uri.getHost(), uri.getPort() > 0 ? String.format(":%d", uri.getPort()) : "", uri.getPath(), response.status(), response.reason(), System.currentTimeMillis() - start});
        }
        return response;
    }

    private static URI createUri(String uri) {
        URI addr = URI.create(uri);
        if (addr.getPath() != null && addr.getPath().isEmpty()) {
            addr = UriBuilder.fromUri((URI)addr).path("/").build(new Object[0]);
        }
        return addr;
    }

    private static <T extends Wire> Constructor<?> findCtor(Class<T> type, Object ... args) {
        Constructor<?> ctor = null;
        for (Constructor<?> opt : type.getDeclaredConstructors()) {
            Class<?>[] types = opt.getParameterTypes();
            if (types.length != args.length + 1) continue;
            boolean match = true;
            for (int inx = 1; inx < types.length && match; ++inx) {
                match = BaseRequest.wrappedIfNeeded(types[inx]).isAssignableFrom(args[inx - 1].getClass());
            }
            if (!match) continue;
            ctor = opt;
            break;
        }
        if (ctor == null) {
            throw new IllegalArgumentException(String.format("class %s doesn't have a ctor with %d argument(s)", type.getName(), args.length));
        }
        return ctor;
    }

    private static Class<?> wrappedIfNeeded(Class<?> type) {
        Class arg = type;
        if (arg.isPrimitive()) {
            arg = ClassUtil.wrapperType(arg);
        }
        return arg;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseRequest)) {
            return false;
        }
        BaseRequest other = (BaseRequest)o;
        String this$home = this.home;
        String other$home = other.home;
        if (this$home == null ? other$home != null : !this$home.equals(other$home)) {
            return false;
        }
        String this$mtd = this.mtd;
        String other$mtd = other.mtd;
        if (this$mtd == null ? other$mtd != null : !this$mtd.equals(other$mtd)) {
            return false;
        }
        Array<Map.Entry<String, String>> this$hdrs = this.hdrs;
        Array<Map.Entry<String, String>> other$hdrs = other.hdrs;
        if (this$hdrs == null ? other$hdrs != null : !this$hdrs.equals(other$hdrs)) {
            return false;
        }
        return Arrays.equals(this.content, other.content);
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $home = this.home;
        result = result * 59 + ($home == null ? 43 : $home.hashCode());
        String $mtd = this.mtd;
        result = result * 59 + ($mtd == null ? 43 : $mtd.hashCode());
        Array<Map.Entry<String, String>> $hdrs = this.hdrs;
        result = result * 59 + ($hdrs == null ? 43 : $hdrs.hashCode());
        result = result * 59 + Arrays.hashCode(this.content);
        return result;
    }

    @Immutable
    @Loggable(value=1)
    private static final class BaseUri
    implements RequestURI {
        private final transient String address;
        private final transient BaseRequest owner;

        BaseUri(BaseRequest req, String uri) {
            this.owner = req;
            this.address = uri;
        }

        public String toString() {
            return this.address;
        }

        @Override
        public Request back() {
            return new BaseRequest(this.owner.wire, this.address, (Iterable<Map.Entry<String, String>>)this.owner.hdrs, this.owner.mtd, this.owner.content, this.owner.connect, this.owner.read);
        }

        @Override
        public URI get() {
            return URI.create(this.owner.home);
        }

        @Override
        public RequestURI set(URI uri) {
            return new BaseUri(this.owner, uri.toString());
        }

        @Override
        public RequestURI queryParam(String name, Object value) {
            return new BaseUri(this.owner, UriBuilder.fromUri((String)this.address).queryParam(name, new Object[]{"{value}"}).build(new Object[]{value}).toString());
        }

        @Override
        public RequestURI queryParams(Map<String, String> map) {
            UriBuilder uri = UriBuilder.fromUri((String)this.address);
            Object[] values = new Object[map.size()];
            int idx = 0;
            for (Map.Entry<String, String> pair : map.entrySet()) {
                uri.queryParam(pair.getKey(), new Object[]{String.format("{x%d}", idx)});
                values[idx] = pair.getValue();
                ++idx;
            }
            return new BaseUri(this.owner, uri.build(values).toString());
        }

        @Override
        public RequestURI path(String segment) {
            return new BaseUri(this.owner, UriBuilder.fromUri((String)this.address).path(segment).build(new Object[0]).toString());
        }

        @Override
        public RequestURI userInfo(String info) {
            return new BaseUri(this.owner, UriBuilder.fromUri((String)this.address).userInfo(info).build(new Object[0]).toString());
        }

        @Override
        public RequestURI port(int num) {
            return new BaseUri(this.owner, UriBuilder.fromUri((String)this.address).port(num).build(new Object[0]).toString());
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BaseUri)) {
                return false;
            }
            BaseUri other = (BaseUri)o;
            String this$address = this.address;
            String other$address = other.address;
            return !(this$address == null ? other$address != null : !this$address.equals(other$address));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $address = this.address;
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            return result;
        }
    }

    @Immutable
    @Loggable(value=1)
    private static final class FormEncodedBody
    implements RequestBody {
        @Immutable.Array
        private final transient byte[] text;
        private final transient BaseRequest owner;

        FormEncodedBody(BaseRequest req, byte[] body) {
            this.owner = req;
            this.text = (byte[])body.clone();
        }

        public String toString() {
            return new RequestBody.Printable(this.text).toString();
        }

        @Override
        public Request back() {
            return new BaseRequest(this.owner.wire, this.owner.home, (Iterable<Map.Entry<String, String>>)this.owner.hdrs, this.owner.mtd, this.text, this.owner.connect, this.owner.read);
        }

        @Override
        public String get() {
            return new String(this.text, CHARSET);
        }

        @Override
        public RequestBody set(String txt) {
            return this.set(txt.getBytes(CHARSET));
        }

        @Override
        public RequestBody set(JsonStructure json) {
            StringWriter writer = new StringWriter();
            Json.createWriter((Writer)writer).write(json);
            return this.set(writer.toString());
        }

        @Override
        public RequestBody set(byte[] txt) {
            return new FormEncodedBody(this.owner, txt);
        }

        @Override
        public RequestBody formParam(String name, Object value) {
            try {
                StringBuilder builder = new StringBuilder(this.get());
                if (!builder.toString().isEmpty()) {
                    builder.append('&');
                }
                return new FormEncodedBody(this.owner, builder.append(name).append('=').append(URLEncoder.encode(value.toString(), BaseRequest.ENCODING)).toString().getBytes(CHARSET));
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalStateException(ex);
            }
        }

        @Override
        public RequestBody formParams(Map<String, String> params) {
            RequestBody body = this;
            for (Map.Entry<String, String> param : params.entrySet()) {
                body = body.formParam(param.getKey(), param.getValue());
            }
            return body;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FormEncodedBody)) {
                return false;
            }
            FormEncodedBody other = (FormEncodedBody)o;
            return Arrays.equals(this.text, other.text);
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.text);
            return result;
        }
    }

    private static final class MultipartFormBody
    implements RequestBody {
        @Immutable.Array
        private final transient byte[] text;
        private final transient BaseRequest owner;

        MultipartFormBody(BaseRequest req, byte[] body) {
            this.owner = req;
            this.text = (byte[])body.clone();
        }

        public String toString() {
            return new RequestBody.Printable(this.text).toString();
        }

        @Override
        public Request back() {
            return new BaseRequest(this.owner.wire, this.owner.home, (Iterable<Map.Entry<String, String>>)this.owner.hdrs, this.owner.mtd, this.text, this.owner.connect, this.owner.read);
        }

        @Override
        public String get() {
            return new String(this.text, CHARSET);
        }

        @Override
        public RequestBody set(String txt) {
            return this.set(txt.getBytes(CHARSET));
        }

        @Override
        public RequestBody set(JsonStructure json) {
            StringWriter writer = new StringWriter();
            Json.createWriter((Writer)writer).write(json);
            return this.set(writer.toString());
        }

        @Override
        public RequestBody set(byte[] txt) {
            return new MultipartFormBody(this.owner, txt);
        }

        @Override
        public RequestBody formParam(String name, Object value) {
            String boundary = this.boundary();
            String dashes = "--";
            byte[] last = Arrays.copyOfRange(this.text, Math.max(this.text.length - 2, 0), this.text.length);
            byte[] old = Arrays.equals(last, "--".getBytes(CHARSET)) ? Arrays.copyOf(this.text, this.text.length - 2) : String.format("%s%s", "--", boundary).getBytes(CHARSET);
            byte[] bytes = value instanceof byte[] ? (byte[])value : value.toString().getBytes(CHARSET);
            byte[] disposition = Joiner.on((String)"; ").join((Object)"Content-Disposition: form-data", (Object)String.format("name=\"%s\"", name), new Object[]{"filename=\"binary\""}).getBytes(CHARSET);
            byte[] type = "Content-Type: application/octet-stream".getBytes(CHARSET);
            byte[] footer = String.format("%s%s%s", "--", boundary, "--").getBytes(CHARSET);
            MultipartBodyBuilder neww = new MultipartBodyBuilder().appendLine(old).appendLine(disposition).appendLine(type).appendLine(new byte[0]).appendLine(bytes).append(footer);
            return new MultipartFormBody(this.owner, neww.asBytes());
        }

        @Override
        public RequestBody formParams(Map<String, String> params) {
            RequestBody body = this;
            for (Map.Entry<String, String> param : params.entrySet()) {
                body = body.formParam(param.getKey(), param.getValue());
            }
            return body;
        }

        private String boundary() {
            for (Map.Entry hdr : this.owner.hdrs) {
                if (!((String)hdr.getKey()).equals("Content-Type") || !((String)hdr.getValue()).matches(".*;\\s*[bB]oundary=.*")) continue;
                return ((String)hdr.getValue()).replaceFirst(".*;\\s*[bB]oundary=", "");
            }
            throw new IllegalStateException("Content-Type: multipart/form-data requires boundary");
        }
    }
}

