/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.wire;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.jcabi.aspects.Immutable;
import com.jcabi.http.Request;
import com.jcabi.http.Response;
import com.jcabi.http.Wire;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import lombok.Generated;

@Immutable
public final class CachingWire
implements Wire {
    private static final CacheLoader<Wire, LoadingCache<Callable<Response>, Response>> LOADER = new CacheLoader<Wire, LoadingCache<Callable<Response>, Response>>(){

        public LoadingCache<Callable<Response>, Response> load(Wire key) {
            return CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Callable<Response>, Response>(){

                public Response load(Callable<Response> query) throws Exception {
                    return query.call();
                }
            });
        }
    };
    private static final LoadingCache<Wire, LoadingCache<Callable<Response>, Response>> CACHE = CacheBuilder.newBuilder().build(LOADER);
    private static final String NEVER = "$never";
    private final transient Wire origin;
    private final transient String regex;
    private final LoadingCache<Callable<Response>, Response> cache;

    public CachingWire(Wire wire) {
        this(wire, NEVER);
    }

    public CachingWire(Wire wire, String flsh) {
        this.origin = wire;
        this.regex = flsh;
        this.cache = (LoadingCache)CACHE.getUnchecked((Object)this);
    }

    public CachingWire(Wire wire, LoadingCache<Callable<Response>, Response> storage) {
        this(wire, NEVER, storage);
    }

    public CachingWire(Wire wire, String flsh, LoadingCache<Callable<Response>, Response> storage) {
        this.origin = wire;
        this.regex = flsh;
        this.cache = storage;
    }

    @Override
    public Response send(Request req, String home, String method, Collection<Map.Entry<String, String>> headers, InputStream content, int connect, int read) throws IOException {
        Response rsp;
        URI uri = req.uri().get();
        StringBuilder label = new StringBuilder(100).append(method).append(' ').append(uri.getPath());
        if (uri.getQuery() != null) {
            label.append('?').append(uri.getQuery());
        }
        if (label.toString().matches(this.regex)) {
            this.cache.invalidateAll();
        }
        if (method.equals("GET")) {
            try {
                rsp = (Response)this.cache.get((Object)new Query(this.origin, req, home, headers, content, connect, read));
            }
            catch (ExecutionException ex) {
                throw new IOException(ex);
            }
        } else {
            rsp = this.origin.send(req, home, method, headers, content, connect, read);
        }
        return rsp;
    }

    public static void invalidate() {
        CACHE.invalidateAll();
    }

    @Generated
    public String toString() {
        return "CachingWire(origin=" + this.origin + ", regex=" + this.regex + ", cache=" + this.cache + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CachingWire)) {
            return false;
        }
        CachingWire other = (CachingWire)o;
        Wire this$origin = this.origin;
        Wire other$origin = other.origin;
        if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
            return false;
        }
        String this$regex = this.regex;
        String other$regex = other.regex;
        return !(this$regex == null ? other$regex != null : !this$regex.equals(other$regex));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Wire $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        String $regex = this.regex;
        result = result * 59 + ($regex == null ? 43 : $regex.hashCode());
        return result;
    }

    private static final class Query
    implements Callable<Response> {
        private final transient Wire origin;
        private final transient Request request;
        private final transient String uri;
        private final transient Collection<Map.Entry<String, String>> headers;
        private final transient InputStream body;
        private final transient int connect;
        private final transient int read;

        Query(Wire wire, Request req, String home, Collection<Map.Entry<String, String>> hdrs, InputStream input, int cnct, int rdd) {
            this.origin = wire;
            this.request = req;
            this.uri = home;
            this.headers = hdrs;
            this.body = input;
            this.connect = cnct;
            this.read = rdd;
        }

        @Override
        public Response call() throws IOException {
            return this.origin.send(this.request, this.uri, "GET", this.headers, this.body, this.connect, this.read);
        }

        @Generated
        public String toString() {
            return "CachingWire.Query(origin=" + this.origin + ", request=" + this.request + ", uri=" + this.uri + ", headers=" + this.headers + ", body=" + this.body + ", connect=" + this.connect + ", read=" + this.read + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Query)) {
                return false;
            }
            Query other = (Query)o;
            Wire this$origin = this.origin;
            Wire other$origin = other.origin;
            if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
                return false;
            }
            Request this$request = this.request;
            Request other$request = other.request;
            if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
                return false;
            }
            String this$uri = this.uri;
            String other$uri = other.uri;
            if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
                return false;
            }
            Collection<Map.Entry<String, String>> this$headers = this.headers;
            Collection<Map.Entry<String, String>> other$headers = other.headers;
            return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Wire $origin = this.origin;
            result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
            Request $request = this.request;
            result = result * 59 + ($request == null ? 43 : $request.hashCode());
            String $uri = this.uri;
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            Collection<Map.Entry<String, String>> $headers = this.headers;
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            return result;
        }
    }
}

