/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.hickory.testing;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import net.java.dev.hickory.testing.MemFileManager;
import net.java.dev.hickory.testing.MemSourceFileObject;
import net.java.dev.hickory.testing.TestCode;

public class RuntimeTest {
    private static int counter = 0;
    private Method testMethod;
    private Class<?> testClass;

    RuntimeTest(TestCode code, MemFileManager jfm) throws IllegalArgumentException {
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        String className = "Generated_RuntimeTest_" + counter++;
        String fqn = code.packageName == null ? className : code.packageName + "." + className;
        MemSourceFileObject src = new MemSourceFileObject(fqn);
        if (code.packageName != null) {
            src.addLine("package " + code.packageName + ";");
        }
        for (String imp : code.imports) {
            src.addLine("import " + imp + ";");
        }
        src.addLine("final public class " + className + "{");
        String methodName = "run";
        StringBuilder b = new StringBuilder();
        b.append("public static ").append(code.returnType).append(" ").append(methodName).append("(");
        String sep = "";
        for (String formal : code.formals) {
            b.append(sep).append(formal);
            sep = ", ";
        }
        b.append(") throws Exception {");
        src.addLine(b.toString());
        src.addLine(code.body.toString());
        src.addLine("}}");
        List<MemSourceFileObject> jfos = Arrays.asList(src);
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        JavaCompiler.CompilationTask task = compiler.getTask(null, jfm, diagnostics, Arrays.asList("-classpath", System.getProperty("java.class.path")), null, jfos);
        if (task.call().booleanValue()) {
            try {
                this.testClass = jfm.getClassLoader(StandardLocation.CLASS_OUTPUT).loadClass(fqn);
                this.testMethod = this.testClass.getDeclaredMethods()[0];
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Unexpected exception", ex);
            }
        } else {
            String sourceCode = null;
            sourceCode = ((Object)src.getCharContent(false)).toString();
            throw new IllegalArgumentException(diagnostics.getDiagnostics().toString() + "\n" + sourceCode);
        }
    }

    public Object run(Object ... args) throws IllegalArgumentException, Exception {
        try {
            return this.testMethod.invoke(null, args);
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("unexpected", ex);
        }
    }
}

