/*
 * Decompiled with CFR 0.152.
 */
package com.klarna.hiverunner.data;

import com.klarna.hiverunner.data.FileParser;
import com.klarna.hiverunner.data.TableDataBuilder;
import com.klarna.hiverunner.data.TableDataInserter;
import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.hcatalog.api.HCatClient;
import org.apache.hive.hcatalog.api.HCatTable;
import org.apache.hive.hcatalog.common.HCatException;

public final class InsertIntoTable {
    private final TableDataBuilder builder;
    private final TableDataInserter inserter;

    public static InsertIntoTable newInstance(String databaseName, String tableName, HiveConf conf) {
        TableDataBuilder builder = new TableDataBuilder(InsertIntoTable.getHCatTable(databaseName, tableName, conf));
        TableDataInserter inserter = new TableDataInserter(databaseName, tableName, conf);
        return new InsertIntoTable(builder, inserter);
    }

    private static HCatTable getHCatTable(String databaseName, String tableName, HiveConf conf) {
        HCatClient client = null;
        try {
            client = HCatClient.create((Configuration)conf);
            HCatTable hCatTable = client.getTable(databaseName, tableName);
            return hCatTable;
        }
        catch (HCatException e) {
            throw new RuntimeException("Unable to get table from the metastore.", e);
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (HCatException e) {
                    throw new RuntimeException("Unable close client.", e);
                }
            }
        }
    }

    InsertIntoTable(TableDataBuilder builder, TableDataInserter inserter) {
        this.builder = builder;
        this.inserter = inserter;
    }

    public InsertIntoTable withColumns(String ... names) {
        this.builder.withColumns(names);
        return this;
    }

    public InsertIntoTable withAllColumns() {
        this.builder.withAllColumns();
        return this;
    }

    public InsertIntoTable newRow() {
        this.builder.newRow();
        return this;
    }

    public InsertIntoTable addRow(Object ... values) {
        this.builder.addRow(values);
        return this;
    }

    public InsertIntoTable setRow(Object ... values) {
        this.builder.setRow(values);
        return this;
    }

    public InsertIntoTable addRowsFromTsv(File file) {
        this.builder.addRowsFromTsv(file);
        return this;
    }

    public InsertIntoTable addRowsFromDelimited(File file, String delimiter, Object nullValue) {
        this.builder.addRowsFromDelimited(file, delimiter, nullValue);
        return this;
    }

    public InsertIntoTable addRowsFrom(File file, FileParser fileParser) {
        this.builder.addRowsFrom(file, fileParser);
        return this;
    }

    public InsertIntoTable copyRow() {
        this.builder.copyRow();
        return this;
    }

    public InsertIntoTable set(String name, Object value) {
        this.builder.set(name, value);
        return this;
    }

    public void commit() {
        this.inserter.insert(this.builder.build());
    }
}

