/*
 * Decompiled with CFR 0.152.
 */
package com.klarna.hiverunner.sql.split;

import com.klarna.hiverunner.sql.cli.CommandShellEmulator;
import com.klarna.hiverunner.sql.split.BaseContext;
import com.klarna.hiverunner.sql.split.TokenRule;
import java.util.List;
import java.util.StringTokenizer;

public class StatementSplitter {
    public static final String SQL_SPECIAL_CHARS = ";\"'-\n\r\f";
    private final List<TokenRule> rules;
    private final String specialChars;

    public StatementSplitter(CommandShellEmulator emulator) {
        this(emulator.splitterRules(), emulator.specialCharacters());
    }

    public StatementSplitter(List<TokenRule> rules, String specialChars) {
        this.rules = rules;
        this.specialChars = specialChars;
    }

    public List<String> split(String expression) {
        StringTokenizer tokenizer = new StringTokenizer(expression, this.specialChars, true);
        BaseContext context = new BaseContext(tokenizer);
        block0: while (tokenizer.hasMoreElements()) {
            String token = (String)tokenizer.nextElement();
            for (TokenRule rule : this.rules) {
                if (!rule.triggers().contains(token) && !rule.triggers().isEmpty()) continue;
                rule.handle(token, context);
                continue block0;
            }
        }
        context.flush();
        return context.getStatements();
    }
}

